/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.petstore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.drools.FactException;
import org.drools.examples.petstore.CartItem;
import org.drools.examples.petstore.CheckoutCallback;

public class PetStoreUI
extends JPanel {
    private JTextArea output;
    private TableModel tableModel;
    private CheckoutCallback callback;
    static /* synthetic */ Class class$org$drools$examples$petstore$CartItem;

    public PetStoreUI(Vector items, CheckoutCallback callback) {
        super(new BorderLayout());
        this.callback = callback;
        JSplitPane splitPane = new JSplitPane(0);
        this.add((Component)splitPane, "Center");
        JPanel topHalf = new JPanel();
        topHalf.setLayout(new BoxLayout(topHalf, 0));
        topHalf.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        topHalf.setMinimumSize(new Dimension(400, 50));
        topHalf.setPreferredSize(new Dimension(450, 250));
        splitPane.add(topHalf);
        JPanel bottomHalf = new JPanel(new BorderLayout());
        bottomHalf.setMinimumSize(new Dimension(400, 50));
        bottomHalf.setPreferredSize(new Dimension(450, 300));
        splitPane.add(bottomHalf);
        JPanel listContainer = new JPanel(new GridLayout(1, 1));
        listContainer.setBorder(BorderFactory.createTitledBorder("List"));
        topHalf.add(listContainer);
        JList list = new JList(items);
        ListSelectionModel listSelectionModel = list.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        list.addMouseListener(new ListSelectionHandler());
        JScrollPane listPane = new JScrollPane(list);
        listContainer.add(listPane);
        JPanel tableContainer = new JPanel(new GridLayout(1, 1));
        tableContainer.setBorder(BorderFactory.createTitledBorder("Table"));
        topHalf.add(tableContainer);
        this.tableModel = new TableModel();
        JTable table = new JTable(this.tableModel);
        table.addMouseListener(new TableSelectionHandler());
        ListSelectionModel tableSelectionModel = table.getSelectionModel();
        tableSelectionModel.setSelectionMode(0);
        TableColumnModel tableColumnModel = table.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new NameRenderer());
        tableColumnModel.getColumn(1).setCellRenderer(new PriceRenderer());
        tableColumnModel.getColumn(1).setMaxWidth(50);
        JScrollPane tablePane = new JScrollPane(table);
        tablePane.setPreferredSize(new Dimension(150, 100));
        tableContainer.add(tablePane);
        JPanel checkoutPane = new JPanel();
        JButton button = new JButton("Checkout");
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(10);
        button.addMouseListener(new CheckoutButtonHandler());
        button.setActionCommand("checkout");
        checkoutPane.add(button);
        bottomHalf.add((Component)checkoutPane, "North");
        button = new JButton("Reset");
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(11);
        button.addMouseListener(new ResetButtonHandler());
        button.setActionCommand("reset");
        checkoutPane.add(button);
        bottomHalf.add((Component)checkoutPane, "North");
        this.output = new JTextArea(1, 10);
        this.output.setEditable(false);
        JScrollPane outputPane = new JScrollPane(this.output, 22, 30);
        bottomHalf.add((Component)outputPane, "Center");
    }

    public void createAndShowGUI() {
        JFrame frame = new JFrame("Pet Store Demo");
        frame.setDefaultCloseOperation(3);
        this.setOpaque(true);
        frame.setContentPane(this);
        frame.pack();
        frame.setVisible(true);
    }

    private class TableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Name", "Price"};
        private ArrayList items = new ArrayList();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.items.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.items.get(row);
        }

        public Class getColumnClass(int c) {
            return class$org$drools$examples$petstore$CartItem == null ? (class$org$drools$examples$petstore$CartItem = PetStoreUI.class$("org.drools.examples.petstore.CartItem")) : class$org$drools$examples$petstore$CartItem;
        }

        public void addItem(CartItem item) {
            this.items.add(item);
            this.fireTableRowsInserted(this.items.size(), this.items.size());
        }

        public void removeItem(int row) {
            this.items.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public List getItems() {
            return this.items;
        }

        public void clear() {
            int lastRow = this.items.size();
            this.items.clear();
            this.fireTableRowsDeleted(0, lastRow);
        }
    }

    private class PriceRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            CartItem item = (CartItem)object;
            this.setText(Double.toString(item.getCost()));
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            CartItem item = (CartItem)object;
            this.setText(item.getName());
        }
    }

    private class ResetButtonHandler
    extends MouseAdapter {
        private ResetButtonHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            JButton button = (JButton)e.getComponent();
            PetStoreUI.this.output.setText(null);
            PetStoreUI.this.tableModel.clear();
            System.out.println("------ Reset ------");
        }
    }

    private class CheckoutButtonHandler
    extends MouseAdapter {
        private CheckoutButtonHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            JButton button = (JButton)e.getComponent();
            try {
                PetStoreUI.this.output.append(PetStoreUI.this.callback.checkout((JFrame)button.getTopLevelAncestor(), PetStoreUI.this.tableModel.getItems()));
            }
            catch (FactException fe) {
                fe.printStackTrace();
            }
        }
    }

    private class TableSelectionHandler
    extends MouseAdapter {
        private TableSelectionHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            JTable jtable = (JTable)e.getSource();
            TableModel tableModel = (TableModel)jtable.getModel();
            tableModel.removeItem(jtable.getSelectedRow());
        }
    }

    private class ListSelectionHandler
    extends MouseAdapter {
        private ListSelectionHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            JList jlist = (JList)e.getSource();
            PetStoreUI.this.tableModel.addItem((CartItem)jlist.getSelectedValue());
        }
    }
}

