/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.primefactors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.drools.RuleBase;
import org.drools.RuleBaseBuilder;
import org.drools.WorkingMemory;
import org.drools.examples.primefactors.FactorCondition;
import org.drools.examples.primefactors.FactorConsequence;
import org.drools.examples.primefactors.Number;
import org.drools.io.RuleSetReader;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.semantics.base.ClassObjectType;

public class PrimeFactors {
    private static final String PRIMES_FILE = "primes.txt.gz";
    private static final String DRL_FILE = "primes.java.drl";
    private static final ClassObjectType numberType = new ClassObjectType(Number.class);
    private static int numberOfRules = 100;
    private static int numberOfFacts = 1000;
    private static long randomSeed = 0L;
    private static boolean verbose = false;
    private static int[] primes;
    private static long[] timepoint;

    public static void main(String[] args) throws Exception {
        int i;
        Number fact;
        if (args.length > 0) {
            numberOfRules = Integer.parseInt(args[0]);
        }
        if (numberOfRules < 1) {
            System.out.println("Please enter a number creater than 0 for the number of rules");
            return;
        }
        System.out.println("Number of Rules: " + numberOfRules);
        if (args.length > 1) {
            numberOfFacts = Integer.parseInt(args[1]);
        }
        if (numberOfFacts < 0) {
            System.out.println("Please enter a positive value for the number of facts.");
            return;
        }
        System.out.println("Number of Facts: " + numberOfFacts);
        if (args.length > 2) {
            randomSeed = Long.parseLong(args[2]);
        }
        if (-1L == randomSeed) {
            randomSeed = System.currentTimeMillis();
        }
        System.out.println("Random Seed: " + randomSeed);
        if (args.length > 3) {
            verbose = Boolean.valueOf(args[3]);
        }
        System.out.println("Verbose Output: " + verbose);
        RuleSet ruleSet = new RuleSet("Find Prime Number");
        PrimeFactors.verbose("");
        PrimeFactors.verbose("Reading " + numberOfRules + " primes...");
        PrimeFactors.stopwatch(0);
        PrimeFactors.readPrimes();
        PrimeFactors.verbose("Read " + numberOfRules + " primes" + PrimeFactors.stopwatch(0));
        PrimeFactors.verbose("Creating " + numberOfRules + " rules...");
        for (int i2 = 0; i2 < numberOfRules; ++i2) {
            Rule rule = new Rule("Factor by " + primes[i2]);
            Declaration numberDecl = rule.addParameterDeclaration("number", numberType);
            rule.addCondition(new FactorCondition(numberDecl, primes[i2]));
            rule.setConsequence(new FactorConsequence(numberDecl, primes[i2]));
            ruleSet.addRule(rule);
        }
        PrimeFactors.verbose("Created " + numberOfRules + " rules" + PrimeFactors.stopwatch(0));
        PrimeFactors.verbose("Building RuleBase with " + numberOfRules + " rules...");
        RuleBaseBuilder builder = new RuleBaseBuilder();
        builder.addRuleSet(ruleSet);
        builder.addRuleSet(new RuleSetReader().read(PrimeFactors.class.getResource(DRL_FILE)));
        RuleBase ruleBase = builder.build();
        PrimeFactors.verbose("Built RuleBase with " + numberOfRules + " rules" + PrimeFactors.stopwatch(0));
        PrimeFactors.verbose("Generating " + numberOfFacts + " random numbers to assert...");
        Random random = new Random(randomSeed);
        int[] factValues = new int[numberOfFacts];
        for (int i3 = 0; i3 < numberOfFacts; ++i3) {
            factValues[i3] = random.nextInt(primes[numberOfRules - 1]) + 1;
            if (factValues[i3] >= 1) continue;
            System.out.println("Programmer Error: factValues[" + i3 + "]=" + factValues[i3]);
            return;
        }
        primes = null;
        PrimeFactors.verbose("Generated " + numberOfFacts + " random numbers to assert" + PrimeFactors.stopwatch(0));
        System.out.println();
        System.out.println("== Example #1 ========================================");
        System.out.println("foreach Number {");
        System.out.println("    new WorkingMemory();");
        System.out.println("    assertObject();");
        System.out.println("    fireAllRules();");
        System.out.println("}");
        System.out.println("======================================================");
        LinkedList results = new LinkedList();
        PrimeFactors.stopwatch(0);
        for (int i4 = 0; i4 < numberOfFacts; ++i4) {
            PrimeFactors.stopwatch(1);
            WorkingMemory workingMemory = ruleBase.newWorkingMemory();
            fact = new Number(factValues[i4]);
            workingMemory.assertObject(fact);
            workingMemory.fireAllRules();
            results.addAll(workingMemory.getObjects());
            PrimeFactors.verbose(fact + ":" + PrimeFactors.stopwatch(1));
        }
        System.out.println("Total time:" + PrimeFactors.stopwatch(0));
        PrimeFactors.validate(results);
        System.out.println();
        System.out.println("== Example #2 ========================================");
        System.out.println("new WorkingMemory();");
        System.out.println("foreach Number {");
        System.out.println("    assertObject();");
        System.out.println("    fireAllRules();");
        System.out.println("}");
        System.out.println("======================================================");
        WorkingMemory workingMemory = ruleBase.newWorkingMemory();
        PrimeFactors.stopwatch(0);
        for (i = 0; i < numberOfFacts; ++i) {
            PrimeFactors.stopwatch(1);
            fact = new Number(factValues[i]);
            workingMemory.assertObject(fact);
            workingMemory.fireAllRules();
            PrimeFactors.verbose(fact + ":" + PrimeFactors.stopwatch(1));
        }
        System.out.println("Total time:" + PrimeFactors.stopwatch(0));
        PrimeFactors.validate(workingMemory.getObjects());
        System.out.println();
        System.out.println("== Example #3 ========================================");
        System.out.println("new WorkingMemory();");
        System.out.println("foreach Number {");
        System.out.println("    assertObject();");
        System.out.println("}");
        System.out.println("fireAllRules()");
        System.out.println("======================================================");
        workingMemory = ruleBase.newWorkingMemory();
        PrimeFactors.verbose("Asserting " + numberOfFacts + " facts...");
        PrimeFactors.stopwatch(0);
        for (i = 0; i < numberOfFacts; ++i) {
            workingMemory.assertObject(new Number(factValues[i]));
        }
        PrimeFactors.verbose("Firing all rules...");
        workingMemory.fireAllRules();
        if (verbose) {
            Iterator i5 = workingMemory.getObjects().iterator();
            while (i5.hasNext()) {
                System.out.println(i5.next());
            }
        }
        System.out.println("Total time:" + PrimeFactors.stopwatch(0));
        PrimeFactors.validate(workingMemory.getObjects());
    }

    private static void readPrimes() {
        primes = new int[numberOfRules];
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(PrimeFactors.class.getResource(PRIMES_FILE).openStream())));
            for (int i = 0; i < numberOfRules; ++i) {
                String line = br.readLine();
                if (null == line) {
                    throw new IOException("primes.txt.gz only contained " + i + " primes");
                }
                PrimeFactors.primes[i] = Integer.parseInt(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot access primes.txt.gz properly: " + e.getMessage());
        }
    }

    private static void validate(List objects) {
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            int product = 1;
            Number number = (Number)i.next();
            if (1 != number.getQuotient()) {
                throw new RuntimeException("Error: Quotient != 1: " + number);
            }
            Iterator j = number.getFactors().iterator();
            while (j.hasNext()) {
                int factor = (Integer)j.next();
                product *= factor;
            }
            if (number.getValue() == product) continue;
            throw new RuntimeException("Error: Product of factors doesn't equal number: " + number);
        }
    }

    private static String stopwatch(int i) {
        long now = System.currentTimeMillis();
        String message = " [" + (now - timepoint[i]) / 1000L + " secs]";
        PrimeFactors.timepoint[i] = now;
        return message;
    }

    private static void verbose(String message) {
        if (verbose) {
            System.out.println(message);
        }
    }

    static {
        timepoint = new long[2];
    }
}

