/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.util.HashSet;
import org.drools.io.BaseAbstractHandler;
import org.drools.io.Handler;
import org.drools.io.RuleSetReader;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.smf.Configuration;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.FactoryException;
import org.drools.smf.SemanticModule;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.Duration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ConsequenceHandler
extends BaseAbstractHandler
implements Handler {
    ConsequenceHandler(RuleSetReader ruleSetReader) {
        this.ruleSetReader = ruleSetReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Rule.class);
            this.validPeers = new HashSet();
            this.validPeers.add(Duration.class);
            this.validPeers.add(Condition.class);
            this.validPeers.add(Declaration.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.ruleSetReader.startConfiguration(localName, attrs);
        return null;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.ruleSetReader.endConfiguration();
        SemanticModule module = this.ruleSetReader.lookupSemanticModule(uri, localName);
        ConsequenceFactory factory = module.getConsequenceFactory(localName);
        try {
            Rule rule = (Rule)this.ruleSetReader.getParent(Rule.class);
            Consequence consequence = factory.newConsequence(rule, this.ruleSetReader.getFactoryContext(), config);
            rule.setConsequence(consequence);
        }
        catch (FactoryException e) {
            throw new SAXParseException("error constructing consequence", this.ruleSetReader.getLocator(), e);
        }
        return null;
    }

    public boolean popParent() {
        return true;
    }

    public Class generateNodeFor() {
        return Consequence.class;
    }
}

