/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import org.drools.DroolsException;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;

public class CompilationException
extends DroolsException {
    private final Rule rule;
    private final RuleSet ruleSet;
    private final String text;
    private final int lineNumber;
    private final int columnNumber;
    private final String errorMessage;

    public CompilationException(RuleSet ruleSet, Rule rule, String text, int lineNumber, int columnNumber, String errorMessage) {
        this.ruleSet = ruleSet;
        this.rule = rule;
        this.text = text;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.errorMessage = errorMessage;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public Rule getRule() {
        return this.rule;
    }

    public String getText() {
        return this.text;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumNumber() {
        return this.columnNumber;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getMessage() {
        StringBuffer error = new StringBuffer();
        if (this.ruleSet != null) {
            error.append("RuleSet '");
            error.append(this.getRuleSet().getName());
            error.append("' ");
            error.append(":");
        }
        if (this.rule != null) {
            error.append("Rule '");
            error.append(this.getRule().getName());
            error.append("' ");
            error.append(":");
        }
        error.append(this.getLineNumber());
        error.append(" : ");
        error.append(this.getColumNumber());
        error.append(":\n    ");
        error.append(this.getText());
        error.append("\n");
        error.append(this.getErrorMessage());
        return error.toString();
    }
}

