/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.examples.jiahvac.control.rules;

import org.drools.spring.examples.jiahvac.model.Floor;
import org.drools.spring.examples.jiahvac.model.HeatPump;
import org.drools.spring.examples.jiahvac.model.TempuratureControl;
import org.drools.spring.examples.jiahvac.model.Thermometer;
import org.drools.spring.metadata.annotation.java.Condition;
import org.drools.spring.metadata.annotation.java.Consequence;
import org.drools.spring.metadata.annotation.java.Rule;

@Rule
public class PumpOffWhenFloorsWarmEnough {
    private TempuratureControl control;

    public void setControl(TempuratureControl control) {
        this.control = control;
    }

    @Condition
    public boolean isPumpHeating(HeatPump pump) {
        return pump.getState() == HeatPump.State.HEATING;
    }

    @Condition
    public boolean isPumpServicingFloor(HeatPump pump, Thermometer thermometer) {
        return thermometer.getFloor().getHeatPump() == pump;
    }

    @Condition
    public boolean isAllFloorsWarmEnough(HeatPump pump, Thermometer thermometer) {
        if (!this.control.isWarmEnough(thermometer.getReading())) {
            return false;
        }
        for (Floor floor : pump.getFloors()) {
            if (floor == thermometer.getFloor() || this.control.isWarmEnough(floor.getThermometer().getReading())) continue;
            return false;
        }
        return true;
    }

    @Consequence
    public void consequence(HeatPump pump) {
        pump.setState(HeatPump.State.OFF);
        System.out.println("PumpOffWhenFloorsWarmEnough: " + pump);
    }
}

