/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.factory;

import java.util.Iterator;
import java.util.List;
import org.drools.conflict.CompositeConflictResolver;
import org.drools.spi.ConflictResolver;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ConflictResolverFactoryBean
implements FactoryBean,
InitializingBean {
    private List resolverStrategies;
    private CompositeConflictResolver resolver;

    public void setResolverStrategies(List resolverStrategies) {
        this.resolverStrategies = resolverStrategies;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resolverStrategies == null || this.resolverStrategies.isEmpty()) {
            throw new IllegalArgumentException("resolverStrategies property not specified or is empty");
        }
        Iterator iter = this.resolverStrategies.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof ConflictResolver) continue;
            throw new IllegalArgumentException("resolverStrategies item not instanceof ConflictResolver: " + object.getClass());
        }
    }

    private CompositeConflictResolver createObject() {
        ConflictResolver[] resolvers = this.resolverStrategies.toArray(new ConflictResolver[this.resolverStrategies.size()]);
        return new CompositeConflictResolver(resolvers);
    }

    public Class getObjectType() {
        return ConflictResolver.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        if (this.resolver == null) {
            this.resolver = this.createObject();
        }
        return this.resolver;
    }
}

