/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.helloworld;

import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.event.DebugWorkingMemoryEventListener;
import org.drools.reteoo.Dumper;
import org.drools.reteoo.HelloWorldBuilder;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.Tuple;

public class HelloWorldNative {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) throws Exception {
        Rule helloRule = new Rule("Hello World");
        Rule goodbyeRule = new Rule("Goodbye Cruel World");
        Rule debugRule = new Rule("Debug");
        ClassObjectType StringType = new ClassObjectType(class$java$lang$String == null ? (class$java$lang$String = HelloWorldNative.class$("java.lang.String")) : class$java$lang$String);
        ClassObjectType ObjectType2 = new ClassObjectType(class$java$lang$Object == null ? (class$java$lang$Object = HelloWorldNative.class$("java.lang.Object")) : class$java$lang$Object);
        final Declaration helloDeclaration = helloRule.addParameterDeclaration("hello", StringType);
        final Declaration goodbyeDeclaration = goodbyeRule.addParameterDeclaration("goodbye", StringType);
        final Declaration debugDeclaration = debugRule.addParameterDeclaration("object", ObjectType2);
        Condition conditionHello = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                String hello = (String)tuple.get(helloDeclaration);
                if (hello == null) {
                    return false;
                }
                return hello.equals("Hello");
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{helloDeclaration};
            }
        };
        helloRule.addCondition(conditionHello);
        Condition conditionGoodbye = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                String goodbye = (String)tuple.get(goodbyeDeclaration);
                if (goodbye == null) {
                    return false;
                }
                return goodbye.equals("Goodbye");
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{goodbyeDeclaration};
            }
        };
        goodbyeRule.addCondition(conditionGoodbye);
        Consequence helloConsequence = new Consequence(){

            public void invoke(Tuple tuple, WorkingMemory workingMemory) {
                String hello = (String)tuple.get(helloDeclaration);
                System.out.println(hello + " World");
            }
        };
        helloRule.setConsequence(helloConsequence);
        Consequence goodbyeConsequence = new Consequence(){

            public void invoke(Tuple tuple, WorkingMemory workingMemory) {
                String goodbye = (String)tuple.get(goodbyeDeclaration);
                System.out.println(goodbye + " Cruel World");
            }
        };
        goodbyeRule.setConsequence(goodbyeConsequence);
        Consequence debugConsequence = new Consequence(){

            public void invoke(Tuple tuple, WorkingMemory workingMemory) {
                Object object = tuple.get(debugDeclaration);
                System.out.println("Asserted object: " + object);
            }
        };
        debugRule.setConsequence(debugConsequence);
        RuleSet ruleSet = new RuleSet("Hello World Example");
        ruleSet.addRule(helloRule);
        ruleSet.addRule(goodbyeRule);
        ruleSet.addRule(debugRule);
        HelloWorldBuilder builder = new HelloWorldBuilder(ruleSet);
        RuleBase ruleBase = builder.buildRuleBase();
        System.out.println("DUMP RETE");
        System.out.println("---------");
        Dumper dumper = new Dumper(ruleBase);
        dumper.dumpRete(System.out);
        System.out.println("FIRE RULES(Hello)");
        System.out.println("----------");
        WorkingMemory workingMemory = ruleBase.newWorkingMemory();
        workingMemory.addEventListener(new DebugWorkingMemoryEventListener());
        workingMemory.assertObject("Hello");
        workingMemory.fireAllRules();
        System.out.println("\n");
        System.out.println("FIRE RULES(GoodBye)");
        System.out.println("----------");
        workingMemory = ruleBase.newWorkingMemory();
        workingMemory.addEventListener(new DebugWorkingMemoryEventListener());
        workingMemory.assertObject("Goodbye");
        workingMemory.fireAllRules();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

