/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.manners;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.FactException;
import org.drools.RuleBase;
import org.drools.RuleBaseBuilder;
import org.drools.WorkingMemory;
import org.drools.examples.manners.MannersBase;
import org.drools.examples.manners.model.Context;
import org.drools.examples.manners.model.Guest;
import org.drools.examples.manners.model.LastSeat;
import org.drools.examples.manners.model.Seat;
import org.drools.examples.manners.model.Seating;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Tuple;

public class MannersNative
extends MannersBase {
    private WorkingMemory workingMemory;
    static /* synthetic */ Class class$org$drools$examples$manners$model$Context;
    static /* synthetic */ Class class$org$drools$examples$manners$model$Guest;
    static /* synthetic */ Class class$org$drools$examples$manners$model$Seating;
    static /* synthetic */ Class class$org$drools$examples$manners$model$LastSeat;

    public static void main(String[] args) throws Exception {
        new MannersNative(args).run();
    }

    public MannersNative(String[] args) {
        super(args);
    }

    protected void setUp() throws Exception {
        ClassObjectType contextType = new ClassObjectType(class$org$drools$examples$manners$model$Context == null ? (class$org$drools$examples$manners$model$Context = MannersNative.class$("org.drools.examples.manners.model.Context")) : class$org$drools$examples$manners$model$Context);
        ClassObjectType guestType = new ClassObjectType(class$org$drools$examples$manners$model$Guest == null ? (class$org$drools$examples$manners$model$Guest = MannersNative.class$("org.drools.examples.manners.model.Guest")) : class$org$drools$examples$manners$model$Guest);
        ClassObjectType seatingType = new ClassObjectType(class$org$drools$examples$manners$model$Seating == null ? (class$org$drools$examples$manners$model$Seating = MannersNative.class$("org.drools.examples.manners.model.Seating")) : class$org$drools$examples$manners$model$Seating);
        ClassObjectType lastSeatType = new ClassObjectType(class$org$drools$examples$manners$model$LastSeat == null ? (class$org$drools$examples$manners$model$LastSeat = MannersNative.class$("org.drools.examples.manners.model.LastSeat")) : class$org$drools$examples$manners$model$LastSeat);
        RuleSet ruleSet = new RuleSet("Miss Manners");
        Rule findFirstSeatRule = new Rule("find first seat");
        findFirstSeatRule.setSalience(40);
        final Declaration contextDeclA = findFirstSeatRule.addParameterDeclaration("context", contextType);
        final Declaration guestDeclA = findFirstSeatRule.addParameterDeclaration("guest", guestType);
        Condition conditionA1 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Context context = (Context)tuple.get(contextDeclA);
                return context.isState("start");
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{contextDeclA};
            }

            public String toString() {
                return "context.isState(\"start\")";
            }
        };
        findFirstSeatRule.addCondition(conditionA1);
        Consequence consequenceA = new Consequence(){

            public void invoke(Tuple tuple, WorkingMemory workingMemory) throws ConsequenceException {
                Context context = (Context)tuple.get(contextDeclA);
                Guest guest = (Guest)tuple.get(guestDeclA);
                System.out.println("FIRE: find first seat: " + guest);
                try {
                    workingMemory.assertObject(new Seating(1, guest, null));
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
                context.setState("find_seating");
                try {
                    workingMemory.modifyObject(tuple.getFactHandleForObject(context), context);
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        findFirstSeatRule.setConsequence(consequenceA);
        ruleSet.addRule(findFirstSeatRule);
        Rule findSeatingRule = new Rule("find seating");
        findSeatingRule.setSalience(30);
        final Declaration contextDeclB = findSeatingRule.addParameterDeclaration("context", contextType);
        final Declaration guestDeclB = findSeatingRule.addParameterDeclaration("guest", guestType);
        final Declaration seatingDeclB = findSeatingRule.addParameterDeclaration("seating", seatingType);
        Condition conditionB1 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Context context = (Context)tuple.get(contextDeclB);
                return context.isState("find_seating");
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{contextDeclB};
            }

            public String toString() {
                return "context.isState(\"find_seating\")";
            }
        };
        findSeatingRule.addCondition(conditionB1);
        Condition conditionB2 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Seating seating = (Seating)tuple.get(seatingDeclB);
                return seating.getGuest2() == null;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{seatingDeclB};
            }

            public String toString() {
                return "seating.getGuest2() == null";
            }
        };
        findSeatingRule.addCondition(conditionB2);
        Condition conditionB3 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Seating seating = (Seating)tuple.get(seatingDeclB);
                Guest guest = (Guest)tuple.get(guestDeclB);
                return !seating.getTabooList().contains(guest);
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{seatingDeclB, guestDeclB};
            }

            public String toString() {
                return "!seating.getTabooList().contains(guest)";
            }
        };
        findSeatingRule.addCondition(conditionB3);
        Condition conditionB4 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Seating seating = (Seating)tuple.get(seatingDeclB);
                Guest guest = (Guest)tuple.get(guestDeclB);
                return seating.getGuest1().hasOppositeSex(guest);
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{seatingDeclB, guestDeclB};
            }

            public String toString() {
                return "seating.getGuest1().hasOppositeSex(guest)";
            }
        };
        findSeatingRule.addCondition(conditionB4);
        Condition conditionB5 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Seating seating = (Seating)tuple.get(seatingDeclB);
                Guest guest = (Guest)tuple.get(guestDeclB);
                return seating.getGuest1().hasSameHobby(guest);
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{seatingDeclB, guestDeclB};
            }

            public String toString() {
                return "seating.getGuest1().hasSameHobby(guest)";
            }
        };
        findSeatingRule.addCondition(conditionB5);
        Consequence consequenceB = new Consequence(){

            public void invoke(Tuple tuple, WorkingMemory workingMemory) throws ConsequenceException {
                Guest guest = (Guest)tuple.get(guestDeclB);
                Seating seating = (Seating)tuple.get(seatingDeclB);
                System.out.println("FIRE: find seating: " + seating + " " + guest);
                Seating nextSeat = new Seating(seating.getSeat2(), guest, seating);
                try {
                    workingMemory.assertObject(nextSeat);
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
                seating.setGuest2(guest);
                seating.getTabooList().add(guest);
                try {
                    workingMemory.modifyObject(tuple.getFactHandleForObject(seating), seating);
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        findSeatingRule.setConsequence(consequenceB);
        ruleSet.addRule(findSeatingRule);
        Rule tryAnotherPathRule = new Rule("try another path");
        tryAnotherPathRule.setSalience(20);
        final Declaration contextDeclC = tryAnotherPathRule.addParameterDeclaration("context", contextType);
        final Declaration lastSeatDeclC = tryAnotherPathRule.addParameterDeclaration("lastSeat", lastSeatType);
        final Declaration seatingDeclC = tryAnotherPathRule.addParameterDeclaration("seating", seatingType);
        Condition conditionC1 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Context context = (Context)tuple.get(contextDeclC);
                return context.isState("find_seating");
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{contextDeclC};
            }

            public String toString() {
                return "context.isState(\"find_seating\")";
            }
        };
        tryAnotherPathRule.addCondition(conditionC1);
        Condition conditionC2 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                LastSeat lastSeat = (LastSeat)tuple.get(lastSeatDeclC);
                Seating seating = (Seating)tuple.get(seatingDeclC);
                return lastSeat.getSeat() > seating.getSeat1();
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{lastSeatDeclC, seatingDeclC};
            }

            public String toString() {
                return "lastSeat.getSeat() > seating.getSeat1()";
            }
        };
        tryAnotherPathRule.addCondition(conditionC2);
        Condition conditionC3 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Seating seating = (Seating)tuple.get(seatingDeclC);
                return seating.getGuest2() == null;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{seatingDeclC};
            }

            public String toString() {
                return "seating.getGuest2() == null";
            }
        };
        tryAnotherPathRule.addCondition(conditionC3);
        Consequence consequenceC = new Consequence(){

            public void invoke(Tuple tuple, WorkingMemory workingMemory) throws ConsequenceException {
                Seating seating = (Seating)tuple.get(seatingDeclC);
                System.out.println("FIRE: try another path: " + seating);
                Seating prevSeat = seating.getPrevSeat();
                prevSeat.setGuest2(null);
                try {
                    workingMemory.modifyObject(tuple.getFactHandleForObject(prevSeat), prevSeat);
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
                try {
                    workingMemory.retractObject(tuple.getFactHandleForObject(seating));
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        tryAnotherPathRule.setConsequence(consequenceC);
        ruleSet.addRule(tryAnotherPathRule);
        Rule weAreDoneRule = new Rule("we are done");
        weAreDoneRule.setSalience(10);
        final Declaration contextDeclD = weAreDoneRule.addParameterDeclaration("context", contextType);
        final Declaration lastSeatDeclD = weAreDoneRule.addParameterDeclaration("lastSeat", lastSeatType);
        final Declaration seatingDeclD = weAreDoneRule.addParameterDeclaration("seating", seatingType);
        Condition conditionD1 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Context context = (Context)tuple.get(contextDeclD);
                return context.isState("find_seating");
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{contextDeclD};
            }

            public String toString() {
                return "context.isState(\"find_seating\")";
            }
        };
        weAreDoneRule.addCondition(conditionD1);
        Condition conditionD2 = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                LastSeat lastSeat = (LastSeat)tuple.get(lastSeatDeclD);
                Seating seating = (Seating)tuple.get(seatingDeclD);
                return lastSeat.getSeat() == seating.getSeat1();
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{lastSeatDeclD, seatingDeclD};
            }

            public String toString() {
                return "lastSeat.getSeat() == seating.getSeat1()";
            }
        };
        weAreDoneRule.addCondition(conditionD2);
        Consequence consequenceD = new Consequence(){

            public void invoke(Tuple tuple, WorkingMemory workingMemory) throws ConsequenceException {
                System.out.println("FIRE: we are done");
                Context context = (Context)tuple.get(contextDeclD);
                ArrayList<Seat> list = new ArrayList<Seat>();
                for (Seating seating = (Seating)tuple.get(seatingDeclD); seating != null; seating = seating.getPrevSeat()) {
                    Seat seat = new Seat(seating.getSeat1(), seating.getGuest1().getName());
                    list.add(seat);
                }
                for (int i = list.size(); i > 0; --i) {
                    Seat seat = (Seat)list.get(i - 1);
                    System.out.println(seat);
                    try {
                        workingMemory.assertObject(seat);
                        continue;
                    }
                    catch (FactException e) {
                        throw new ConsequenceException(e);
                    }
                }
                context.setState("all_done");
                try {
                    workingMemory.modifyObject(tuple.getFactHandleForObject(context), context);
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        weAreDoneRule.setConsequence(consequenceD);
        ruleSet.addRule(weAreDoneRule);
        RuleBaseBuilder builder = new RuleBaseBuilder();
        builder.addRuleSet(ruleSet);
        RuleBase ruleBase = builder.build();
        this.workingMemory = ruleBase.newWorkingMemory();
    }

    protected void tearDown() throws Exception {
        this.workingMemory = null;
    }

    protected List test(List inList) throws Exception {
        Iterator i = inList.iterator();
        while (i.hasNext()) {
            this.workingMemory.assertObject(i.next());
        }
        this.workingMemory.fireAllRules();
        return this.workingMemory.getObjects();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

