/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.drools.RuleBase;
import org.drools.conflict.DefaultConflictResolver;
import org.drools.io.RuleSetReader;
import org.drools.rule.RuleSet;
import org.drools.spi.ConflictResolver;

public class RuleBaseBuilder {
    public static RuleBase buildFromUrl(URL url) throws Exception {
        return RuleBaseBuilder.buildFromUrl(url, DefaultConflictResolver.getInstance());
    }

    public static RuleBase buildFromUrl(URL url, ConflictResolver resolver) throws Exception {
        return RuleBaseBuilder.buildFromUrl(new URL[]{url}, resolver);
    }

    public static RuleBase buildFromUrl(URL[] urls) throws Exception {
        return RuleBaseBuilder.buildFromUrl(urls, DefaultConflictResolver.getInstance());
    }

    public static RuleBase buildFromUrl(URL[] urls, ConflictResolver resolver) throws Exception {
        org.drools.RuleBaseBuilder builder = new org.drools.RuleBaseBuilder();
        builder.setConflictResolver(resolver);
        for (int i = 0; i < urls.length; ++i) {
            RuleSetReader reader = new RuleSetReader();
            RuleSet ruleSet = reader.read(urls[i]);
            builder.addRuleSet(ruleSet);
        }
        return builder.build();
    }

    public static RuleBase buildFromInputStream(InputStream in) throws Exception {
        return RuleBaseBuilder.buildFromInputStream(in, DefaultConflictResolver.getInstance());
    }

    public static RuleBase buildFromInputStream(InputStream in, ConflictResolver resolver) throws Exception {
        return RuleBaseBuilder.buildFromInputStream(new InputStream[]{in}, resolver);
    }

    public static RuleBase buildFromInputStream(InputStream[] ins) throws Exception {
        return RuleBaseBuilder.buildFromInputStream(ins, DefaultConflictResolver.getInstance());
    }

    public static RuleBase buildFromInputStream(InputStream[] ins, ConflictResolver resolver) throws Exception {
        org.drools.RuleBaseBuilder builder = new org.drools.RuleBaseBuilder();
        builder.setConflictResolver(resolver);
        for (int i = 0; i < ins.length; ++i) {
            RuleSetReader reader = new RuleSetReader();
            RuleSet ruleSet = reader.read(ins[i]);
            builder.addRuleSet(ruleSet);
        }
        return builder.build();
    }

    public static RuleBase buildFromReader(Reader in) throws Exception {
        return RuleBaseBuilder.buildFromReader(in, DefaultConflictResolver.getInstance());
    }

    public static RuleBase buildFromReader(Reader in, ConflictResolver resolver) throws Exception {
        return RuleBaseBuilder.buildFromReader(new Reader[]{in}, resolver);
    }

    public static RuleBase buildFromReader(Reader[] ins) throws Exception {
        return RuleBaseBuilder.buildFromReader(ins, DefaultConflictResolver.getInstance());
    }

    public static RuleBase buildFromReader(Reader[] ins, ConflictResolver resolver) throws Exception {
        org.drools.RuleBaseBuilder builder = new org.drools.RuleBaseBuilder();
        builder.setConflictResolver(resolver);
        for (int i = 0; i < ins.length; ++i) {
            RuleSetReader reader = new RuleSetReader();
            RuleSet ruleSet = reader.read(ins[i]);
            builder.addRuleSet(ruleSet);
        }
        return builder.build();
    }
}

