/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.RuleExecutionSetMetadata;
import javax.rules.RuleSession;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.RuleExecutionSet;
import org.drools.WorkingMemory;
import org.drools.jsr94.rules.RuleExecutionSetMetadataImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

abstract class RuleSessionImpl
implements RuleSession {
    private WorkingMemory workingMemory;
    private RuleExecutionSetImpl ruleSet;
    private Map properties;

    RuleSessionImpl() {
    }

    protected void initWorkingMemory() {
        this.setWorkingMemory(this.newWorkingMemory());
    }

    protected WorkingMemory newWorkingMemory() {
        WorkingMemory newWorkingMemory = this.getRuleExecutionSet().newWorkingMemory();
        Map props = this.getProperties();
        if (props != null) {
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                newWorkingMemory.setApplicationData((String)entry.getKey(), entry.getValue());
            }
        }
        return newWorkingMemory;
    }

    protected void setProperties(Map properties) {
        this.properties = properties;
    }

    protected Map getProperties() {
        return this.properties;
    }

    protected void setWorkingMemory(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    protected WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    protected void setRuleExecutionSet(RuleExecutionSetImpl ruleSet) {
        this.ruleSet = ruleSet;
    }

    protected RuleExecutionSetImpl getRuleExecutionSet() {
        return this.ruleSet;
    }

    protected void checkRuleSessionValidity() throws InvalidRuleSessionException {
        if (this.workingMemory == null) {
            throw new InvalidRuleSessionException("invalid rule session");
        }
    }

    protected void applyFilter(List objects, ObjectFilter objectFilter) {
        if (objectFilter != null) {
            Iterator objectIter = objects.iterator();
            while (objectIter.hasNext()) {
                if (objectFilter.filter(objectIter.next()) != null) continue;
                objectIter.remove();
            }
        }
    }

    public RuleExecutionSetMetadata getRuleExecutionSetMetadata() {
        RuleExecutionSetRepository repository = RuleExecutionSetRepository.getInstance();
        String theBindUri = null;
        Iterator i = repository.getRegistrations().iterator();
        while (i.hasNext()) {
            String aBindUri = (String)i.next();
            RuleExecutionSet aRuleSet = repository.getRuleExecutionSet(aBindUri);
            if (aRuleSet != this.ruleSet) continue;
            theBindUri = aBindUri;
            break;
        }
        return new RuleExecutionSetMetadataImpl(theBindUri, this.ruleSet.getName(), this.ruleSet.getDescription());
    }

    public int getType() throws InvalidRuleSessionException {
        if (this instanceof StatelessRuleSession) {
            return 1;
        }
        if (this instanceof StatefulRuleSession) {
            return 0;
        }
        throw new InvalidRuleSessionException("unknown type");
    }

    public void release() {
        this.setProperties(null);
        this.setWorkingMemory(null);
        this.setRuleExecutionSet(null);
    }

    public void reset() {
        this.initWorkingMemory();
    }
}

