/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.StatelessRuleSession;
import org.drools.FactException;
import org.drools.WorkingMemory;
import org.drools.jsr94.rules.RuleSessionImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

public class StatelessRuleSessionImpl
extends RuleSessionImpl
implements StatelessRuleSession {
    StatelessRuleSessionImpl(String bindUri, Map properties) throws RuleExecutionSetNotFoundException {
        this.setProperties(properties);
        RuleExecutionSetRepository repository = RuleExecutionSetRepository.getInstance();
        RuleExecutionSetImpl ruleSet = (RuleExecutionSetImpl)repository.getRuleExecutionSet(bindUri);
        if (ruleSet == null) {
            throw new RuleExecutionSetNotFoundException("RuleExecutionSet unbound: " + bindUri);
        }
        this.setRuleExecutionSet(ruleSet);
    }

    public List executeRules(List objects) throws InvalidRuleSessionException {
        return this.executeRules(objects, this.getRuleExecutionSet().getObjectFilter());
    }

    public List executeRules(List objects, ObjectFilter filter) throws InvalidRuleSessionException {
        WorkingMemory workingMemory = this.newWorkingMemory();
        try {
            Iterator objectIter = objects.iterator();
            while (objectIter.hasNext()) {
                workingMemory.assertObject(objectIter.next());
            }
            workingMemory.fireAllRules();
        }
        catch (FactException e) {
            throw new InvalidRuleSessionException(e.getMessage(), (Exception)e);
        }
        List results = workingMemory.getObjects();
        this.applyFilter(results, filter);
        return results;
    }
}

