/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.util.Map;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetDeregistrationException;
import javax.rules.admin.RuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSetRegisterException;
import org.drools.jsr94.rules.admin.LocalRuleExecutionSetProviderImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetProviderImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

public class RuleAdministratorImpl
implements RuleAdministrator {
    public RuleExecutionSetProvider getRuleExecutionSetProvider(Map properties) {
        return new RuleExecutionSetProviderImpl();
    }

    public LocalRuleExecutionSetProvider getLocalRuleExecutionSetProvider(Map properties) {
        return new LocalRuleExecutionSetProviderImpl();
    }

    public void registerRuleExecutionSet(String bindUri, RuleExecutionSet set, Map properties) throws RuleExecutionSetRegisterException {
        try {
            RuleExecutionSetRepository repository = RuleExecutionSetRepository.getInstance();
            repository.registerRuleExecutionSet(bindUri, set);
        }
        catch (Exception ex) {
            throw new RuleExecutionSetRegisterException("cannot register rule execution set", ex);
        }
    }

    public void deregisterRuleExecutionSet(String bindUri, Map properties) throws RuleExecutionSetDeregistrationException {
        RuleExecutionSetRepository repository = RuleExecutionSetRepository.getInstance();
        if (repository.getRuleExecutionSet(bindUri) == null) {
            throw new RuleExecutionSetDeregistrationException("no execution set bound to: " + bindUri);
        }
        try {
            repository.unregisterRuleExecutionSet(bindUri);
        }
        catch (Exception ex) {
            throw new RuleExecutionSetDeregistrationException("cannot unregister rule set", ex);
        }
    }
}

