/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetProvider;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.drools.io.RuleSetReader;
import org.drools.jsr94.rules.admin.LocalRuleExecutionSetProviderImpl;
import org.drools.rule.RuleSet;
import org.drools.smf.DefaultSemanticsRepository;
import org.w3c.dom.Element;

public class RuleExecutionSetProviderImpl
implements RuleExecutionSetProvider {
    public RuleExecutionSet createRuleExecutionSet(Element ruleExecutionSetElement, Map properties) throws RuleExecutionSetCreateException {
        RuleSetReader reader;
        DOMSource source = new DOMSource(ruleExecutionSetElement);
        try {
            reader = new RuleSetReader(DefaultSemanticsRepository.getInstance());
        }
        catch (Exception e) {
            throw new RuleExecutionSetCreateException("Couldn't get an instance of the DefaultSemanticsRepository: " + e);
        }
        try {
            SAXResult result = new SAXResult(reader);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            System.out.println(result.toString());
        }
        catch (TransformerException e) {
            throw new RuleExecutionSetCreateException("could not create RuleExecutionSet: " + e);
        }
        try {
            RuleSet ruleSet = reader.getRuleSet();
            LocalRuleExecutionSetProviderImpl localRuleExecutionSetProvider = new LocalRuleExecutionSetProviderImpl();
            return localRuleExecutionSetProvider.createRuleExecutionSet((Object)ruleSet, properties);
        }
        catch (Exception e) {
            throw new RuleExecutionSetCreateException("could not create RuleExecutionSet: " + e);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Serializable ruleExecutionSetAst, Map properties) throws RuleExecutionSetCreateException {
        if (ruleExecutionSetAst instanceof RuleSet) {
            LocalRuleExecutionSetProviderImpl localRuleExecutionSetProvider = new LocalRuleExecutionSetProviderImpl();
            return localRuleExecutionSetProvider.createRuleExecutionSet(ruleExecutionSetAst, properties);
        }
        throw new IllegalArgumentException("Serializable object must be an instance of org.drools.rule.RuleSet.  It was " + ruleExecutionSetAst.getClass().getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RuleExecutionSet createRuleExecutionSet(String ruleExecutionSetUri, Map properties) throws RuleExecutionSetCreateException, IOException {
        RuleExecutionSet ruleExecutionSet;
        InputStream in = null;
        try {
            try {
                LocalRuleExecutionSetProviderImpl localRuleExecutionSetProvider = new LocalRuleExecutionSetProviderImpl();
                in = new URL(ruleExecutionSetUri).openStream();
                InputStreamReader reader = new InputStreamReader(in);
                ruleExecutionSet = localRuleExecutionSetProvider.createRuleExecutionSet(reader, properties);
                Object var8_9 = null;
                if (in == null) return ruleExecutionSet;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuleExecutionSetCreateException("cannot create rule set", ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            e.printStackTrace();
            return ruleExecutionSet;
        }
        in.close();
        return ruleExecutionSet;
    }
}

