/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.RuleBase;
import org.drools.RuleIntegrationException;
import org.drools.RuleSetIntegrationException;
import org.drools.conflict.DefaultConflictResolver;
import org.drools.reteoo.ConditionNode;
import org.drools.reteoo.DefaultFactHandleFactory;
import org.drools.reteoo.FactHandleFactory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.spi.Condition;
import org.drools.spi.ConflictResolver;

public class Builder {
    private Rete rete;
    private List ruleSets;
    private Map applicationData;
    private FactHandleFactory factHandleFactory;
    private ConflictResolver conflictResolver;

    public Builder() {
        this.reset();
    }

    public RuleBase buildRuleBase() {
        RuleBaseImpl ruleBase = new RuleBaseImpl(this.rete, this.conflictResolver, this.factHandleFactory, this.ruleSets, this.applicationData);
        this.reset();
        return ruleBase;
    }

    public void setFactHandleFactory(FactHandleFactory factHandleFactory) {
        this.factHandleFactory = factHandleFactory;
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public void addRuleSet(RuleSet ruleSet) throws RuleIntegrationException, RuleSetIntegrationException {
        this.ruleSets.add(ruleSet);
        Map newApplicationData = ruleSet.getApplicationData();
        Iterator it = newApplicationData.keySet().iterator();
        while (it.hasNext()) {
            String identifier = (String)it.next();
            Class type = (Class)newApplicationData.get(identifier);
            if (!this.applicationData.containsKey(identifier) || this.applicationData.get(identifier).equals(type)) continue;
            throw new RuleSetIntegrationException(ruleSet);
        }
        this.applicationData.putAll(newApplicationData);
        Rule[] rules = ruleSet.getRules();
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i]);
        }
    }

    protected void addRule(Rule rule) throws RuleIntegrationException {
        LinkedList conds = new LinkedList(rule.getConditions());
        List leafNodes = this.createParameterNodes(rule);
        while (true) {
            boolean performedJoin;
            boolean joinedForCondition = false;
            if (!conds.isEmpty()) {
                this.attachConditions(rule, conds, leafNodes);
            }
            if (!(performedJoin = this.createJoinNodes(leafNodes)) && !conds.isEmpty()) {
                joinedForCondition = this.joinForCondition(conds, leafNodes);
            }
            if (joinedForCondition) continue;
            if (leafNodes.size() <= 1) break;
            if (performedJoin) continue;
            this.joinArbitrary(leafNodes);
        }
        if (leafNodes.size() != 1) {
            throw new RuleIntegrationException(rule);
        }
        TupleSource lastNode = (TupleSource)leafNodes.iterator().next();
        TerminalNode terminal = new TerminalNode(lastNode, rule);
    }

    List createParameterNodes(Rule rule) {
        LinkedList<ParameterNode> leafNodes = new LinkedList<ParameterNode>();
        Iterator declIter = rule.getParameterDeclarations().iterator();
        while (declIter.hasNext()) {
            Declaration eachDecl = (Declaration)declIter.next();
            leafNodes.add(new ParameterNode(this.rete.getOrCreateObjectTypeNode(eachDecl.getObjectType()), eachDecl));
        }
        return leafNodes;
    }

    void attachConditions(Rule rule, List conds, List leafNodes) {
        Iterator condIter = conds.iterator();
        int order = 0;
        while (condIter.hasNext()) {
            Condition eachCond = (Condition)condIter.next();
            TupleSource tupleSource = this.findMatchingTupleSourceForCondition(eachCond, leafNodes);
            if (tupleSource == null) continue;
            condIter.remove();
            leafNodes.remove(tupleSource);
            leafNodes.add(new ConditionNode(rule, tupleSource, eachCond, order++));
        }
    }

    private boolean joinForCondition(List conds, List leafNodes) {
        return this.joinArbitrary(leafNodes);
    }

    private boolean joinArbitrary(List leafNodes) {
        Iterator leafIter = leafNodes.iterator();
        TupleSource left = (TupleSource)leafIter.next();
        if (!leafIter.hasNext()) {
            return false;
        }
        leafIter.remove();
        TupleSource right = (TupleSource)leafIter.next();
        leafIter.remove();
        leafNodes.add(new JoinNode(left, right));
        return true;
    }

    private boolean createJoinNodes(List leafNodes) {
        boolean performedJoin = false;
        Object[] nodesArray = leafNodes.toArray();
        block0: for (int i = 0; i < nodesArray.length; ++i) {
            TupleSource left = (TupleSource)nodesArray[i];
            if (!leafNodes.contains(left)) continue;
            for (int j = i + 1; j < nodesArray.length; ++j) {
                TupleSource right = (TupleSource)nodesArray[j];
                if (!leafNodes.contains(right) || !this.canBeJoined(left, right)) continue;
                leafNodes.remove(left);
                leafNodes.remove(right);
                leafNodes.add(new JoinNode(left, right));
                performedJoin = true;
                continue block0;
            }
        }
        return performedJoin;
    }

    private boolean canBeJoined(TupleSource left, TupleSource right) {
        Set leftDecls = left.getTupleDeclarations();
        Iterator rightDeclIter = right.getTupleDeclarations().iterator();
        while (rightDeclIter.hasNext()) {
            if (!leftDecls.contains(rightDeclIter.next())) continue;
            return true;
        }
        return false;
    }

    TupleSource findMatchingTupleSourceForCondition(Condition condition, List sources) {
        Iterator sourceIter = sources.iterator();
        while (sourceIter.hasNext()) {
            TupleSource eachSource = (TupleSource)sourceIter.next();
            if (!this.matches(condition, eachSource.getTupleDeclarations())) continue;
            return eachSource;
        }
        return null;
    }

    boolean matches(Condition condition, Set declarations) {
        return this.containsAll(declarations, condition.getRequiredTupleMembers());
    }

    private boolean containsAll(Set declarations, Declaration[] requiredDecls) {
        for (int i = requiredDecls.length - 1; i >= 0; --i) {
            if (declarations.contains(requiredDecls[i])) continue;
            return false;
        }
        return true;
    }

    private void reset() {
        this.rete = new Rete();
        this.ruleSets = new ArrayList();
        this.applicationData = new HashMap();
        this.factHandleFactory = new DefaultFactHandleFactory();
        this.conflictResolver = DefaultConflictResolver.getInstance();
    }
}

