/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Rule;
import org.drools.spi.Condition;

class ConditionNode
extends TupleSource
implements TupleSink {
    private final Rule rule;
    private final Condition condition;
    private final TupleSource tupleSource;
    private final int order;

    ConditionNode(Rule rule, TupleSource tupleSource, Condition condition, int order) {
        this.rule = rule;
        this.condition = condition;
        this.tupleSource = tupleSource;
        this.order = order;
        if (tupleSource != null) {
            this.tupleSource.setTupleSink(this);
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Set getTupleDeclarations() {
        return this.tupleSource.getTupleDeclarations();
    }

    public void assertTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        Condition condition = this.getCondition();
        boolean isAllowed = condition.isAllowed(tuple);
        workingMemory.getEventSupport().fireConditionTested(this.rule, condition, tuple, isAllowed);
        if (isAllowed) {
            this.propagateAssertTuple(tuple, workingMemory);
        }
    }

    public void retractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        this.propagateRetractTuples(key, workingMemory);
    }

    public void modifyTuples(FactHandle trigger, TupleSet newTuples, WorkingMemoryImpl workingMemory) throws FactException {
        HashSet<TupleKey> retractedKeys = new HashSet<TupleKey>();
        Iterator tupleIter = newTuples.iterator();
        Condition condition = this.getCondition();
        while (tupleIter.hasNext()) {
            ReteTuple eachTuple = (ReteTuple)tupleIter.next();
            boolean isAllowed = condition.isAllowed(eachTuple);
            workingMemory.getEventSupport().fireConditionTested(this.rule, condition, eachTuple, isAllowed);
            if (isAllowed) continue;
            tupleIter.remove();
            TupleKey eachKey = eachTuple.getKey();
            if (!retractedKeys.add(eachKey)) continue;
            this.propagateRetractTuples(eachKey, workingMemory);
        }
        if (!newTuples.isEmpty()) {
            this.propagateModifyTuples(trigger, newTuples, workingMemory);
        }
    }

    public String toString() {
        return "[ConditionNode: cond=" + this.condition + "]";
    }
}

