/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.rule.Declaration;

class JoinMemory
implements Serializable {
    private final TupleSet leftTuples = new TupleSet();
    private final TupleSet rightTuples = new TupleSet();
    private final Set tupleDeclarations;
    private final Set commonDeclarations;

    JoinMemory(Set tupleDeclarations, Set commonDeclarations) {
        this.tupleDeclarations = tupleDeclarations;
        this.commonDeclarations = commonDeclarations;
    }

    boolean retractTuples(TupleKey key) {
        return this.leftTuples.removeAllTuples(key) | this.rightTuples.removeAllTuples(key);
    }

    TupleSet addLeftTuple(ReteTuple tuple) {
        this.leftTuples.addTuple(tuple);
        return this.attemptJoin(tuple, this.rightTuples);
    }

    TupleSet addRightTuple(ReteTuple tuple) {
        this.rightTuples.addTuple(tuple);
        return this.attemptJoin(tuple, this.leftTuples);
    }

    protected TupleSet getLeftTuples() {
        return this.leftTuples;
    }

    protected TupleSet getRightTuples() {
        return this.rightTuples;
    }

    TupleSet modifyLeftTuples(FactHandle trigger) {
        return this.modifyTuples(trigger, this.getLeftTuples(), this.getRightTuples());
    }

    TupleSet modifyRightTuples(FactHandle trigger) {
        return this.modifyTuples(trigger, this.getRightTuples(), this.getLeftTuples());
    }

    private TupleSet modifyTuples(FactHandle trigger, TupleSet thisSideTuples, TupleSet thatSideTuples) {
        TupleSet newJoined = new TupleSet();
        Iterator tupleIter = thisSideTuples.iterator();
        while (tupleIter.hasNext()) {
            ReteTuple tuple = (ReteTuple)tupleIter.next();
            if (!tuple.dependsOn(trigger)) continue;
            this.attemptJoin(tuple, thatSideTuples, newJoined);
        }
        return newJoined;
    }

    private TupleSet attemptJoin(ReteTuple tuple, TupleSet tupleSet) {
        TupleSet newJoined = new TupleSet(tupleSet.size(), 1.0f);
        this.attemptJoin(tuple, tupleSet, newJoined);
        return newJoined;
    }

    private void attemptJoin(ReteTuple tuple, TupleSet tupleSet, TupleSet newJoined) {
        Iterator tupleIter = tupleSet.iterator();
        while (tupleIter.hasNext()) {
            this.attemptJoin(tuple, (ReteTuple)tupleIter.next(), newJoined);
        }
    }

    private void attemptJoin(ReteTuple left, ReteTuple right, TupleSet newJoined) {
        Iterator declIter = this.commonDeclarations.iterator();
        while (declIter.hasNext()) {
            Declaration eachDecl = (Declaration)declIter.next();
            if (left.getKey().get(eachDecl).equals(right.getKey().get(eachDecl))) continue;
            return;
        }
        newJoined.addTuple(new ReteTuple(left, right));
    }

    public String toString() {
        return "[JoinMemory \n\tleft=" + this.leftTuples + "\n\tright=" + this.rightTuples + "]";
    }

    public void dump() {
        ReteTuple tuple;
        System.err.println("----");
        Iterator it1 = this.leftTuples.getTuples().iterator();
        while (it1.hasNext()) {
            tuple = (ReteTuple)it1.next();
            System.err.println("tuple");
            Iterator it2 = this.tupleDeclarations.iterator();
            while (it2.hasNext()) {
                Declaration decl = (Declaration)it2.next();
                Object object = tuple.get(decl);
                TupleKey key = tuple.getKey();
                System.err.println("dump memory leftTuples:" + key.get(decl) + ":" + decl + ":" + object);
            }
        }
        Collection tuples = this.rightTuples.getTuples();
        it1 = tuples.iterator();
        while (it1.hasNext()) {
            tuple = (ReteTuple)it1.next();
            Iterator it2 = this.tupleDeclarations.iterator();
            while (it2.hasNext()) {
                Declaration decl = (Declaration)it2.next();
                Object object = tuple.get(decl);
                TupleKey key = tuple.getKey();
                System.err.println("dump memory rightTuples:" + key.get(decl) + ":" + decl + ":" + object);
            }
        }
        System.err.println("----");
    }
}

