/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.ObjectType;

class ObjectTypeNode
implements Serializable {
    private ObjectType objectType;
    private Set parameterNodes;

    public ObjectTypeNode(ObjectType objectType) {
        this.objectType = objectType;
        this.parameterNodes = Collections.EMPTY_SET;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    void addParameterNode(ParameterNode node) {
        if (this.parameterNodes == Collections.EMPTY_SET) {
            this.parameterNodes = new HashSet();
        }
        this.parameterNodes.add(node);
    }

    Set getParameterNodes() {
        return this.parameterNodes;
    }

    Iterator getParameterNodeIterator() {
        return this.parameterNodes.iterator();
    }

    void assertObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws FactException {
        if (!this.objectType.matches(object)) {
            return;
        }
        Iterator nodeIter = this.getParameterNodeIterator();
        while (nodeIter.hasNext()) {
            ((ParameterNode)nodeIter.next()).assertObject(handle, object, workingMemory);
        }
    }

    void retractObject(FactHandle handle, WorkingMemoryImpl workingMemory) throws FactException {
        Object object = workingMemory.getObject(handle);
        if (!this.objectType.matches(object)) {
            return;
        }
        Iterator nodeIter = this.getParameterNodeIterator();
        while (nodeIter.hasNext()) {
            ((ParameterNode)nodeIter.next()).retractObject(handle, workingMemory);
        }
    }

    void modifyObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws FactException {
        ObjectType objectType = this.getObjectType();
        Iterator nodeIter = this.getParameterNodeIterator();
        if (!objectType.matches(object)) {
            while (nodeIter.hasNext()) {
                ParameterNode eachNode = (ParameterNode)nodeIter.next();
                eachNode.retractObject(handle, workingMemory);
            }
        } else {
            while (nodeIter.hasNext()) {
                ParameterNode eachNode = (ParameterNode)nodeIter.next();
                eachNode.modifyObject(handle, object, workingMemory);
            }
        }
    }
}

