/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collections;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Declaration;

class ParameterNode
extends TupleSource {
    private final Declaration declaration;
    private final Set declarations;

    public ParameterNode(ObjectTypeNode inputNode, Declaration declaration) {
        this.declaration = declaration;
        this.declarations = Collections.singleton(declaration);
        if (inputNode != null) {
            inputNode.addParameterNode(this);
        }
    }

    void assertObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws AssertionException {
        ReteTuple tuple = new ReteTuple(workingMemory, this.getDeclaration(), handle);
        this.propagateAssertTuple(tuple, workingMemory);
    }

    void retractObject(FactHandle handle, WorkingMemoryImpl workingMemory) throws RetractionException {
        TupleKey key = new TupleKey(this.getDeclaration(), handle);
        this.propagateRetractTuples(key, workingMemory);
    }

    void modifyObject(FactHandle handle, Object newObject, WorkingMemoryImpl workingMemory) throws FactException {
        ReteTuple tuple = new ReteTuple(workingMemory, this.getDeclaration(), handle);
        this.propagateModifyTuples(handle, new TupleSet(tuple), workingMemory);
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public Set getTupleDeclarations() {
        return this.declarations;
    }
}

