/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.reteoo.ConditionNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.JoinNodeInput;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.ReflectiveVisitor;
import org.drools.reteoo.Rete;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSink;
import org.drools.rule.Declaration;

public class ReteooDotDumpVisitor
extends ReflectiveVisitor {
    private static final String NULL_STRING = "<NULL>";
    private static final String INDENT = "    ";
    private PrintStream out = null;
    private Set visitedNodes = new HashSet();
    private int nullDotId = 0;

    public ReteooDotDumpVisitor(PrintStream outPrintStream) {
        this.out = outPrintStream;
    }

    public void visitObject(Object object) {
        this.makeNode(object, "Unknown Object", "object: " + object + ReflectiveVisitor.newline + "class: " + object.getClass());
    }

    public void visitNull() {
        this.makeNode("NULL" + this.nullDotId++, NULL_STRING);
    }

    public void visitRuleBaseImpl(RuleBaseImpl ruleBase) {
        this.visit(ruleBase.getRete());
    }

    public void visitRete(Rete rete) {
        this.makeNode(rete, "RETE-OO");
        Iterator i = rete.getObjectTypeNodeIterator();
        while (i.hasNext()) {
            Object nextNode = i.next();
            this.makeEdge(rete, nextNode);
            this.visitNode(nextNode);
        }
    }

    public void visitObjectTypeNode(ObjectTypeNode node) {
        this.makeNode(node, "ObjectTypeNode", "objectType: " + node.getObjectType());
        Iterator i = node.getParameterNodeIterator();
        while (i.hasNext()) {
            Object nextNode = i.next();
            this.makeEdge(node, nextNode);
            this.visitNode(nextNode);
        }
    }

    public void visitParameterNode(ParameterNode node) {
        this.makeNode(node, "ParameterNode", "TupleSource", "decl: " + ReteooDotDumpVisitor.format(node.getDeclaration()));
        TupleSink nextNode = node.getTupleSink();
        this.makeEdge(node, nextNode);
        this.visitNode(nextNode);
    }

    public void visitConditionNode(ConditionNode node) {
        this.makeNode(node, "ConditionNode", "TupleSource/TupleSink", "condition: " + node.getCondition() + ReflectiveVisitor.newline + this.format(node.getTupleDeclarations(), "tuple"));
        TupleSink nextNode = node.getTupleSink();
        this.makeEdge(node, nextNode);
        this.visitNode(nextNode);
    }

    public void visitJoinNodeInput(JoinNodeInput node) {
        this.makeNode(node, "JoinNodeInput", "TupleSink", node.getSide() == 41 ? "LEFT" : "RIGHT");
        JoinNode nextNode = node.getJoinNode();
        this.makeEdge(node, nextNode);
        this.visitNode(nextNode);
    }

    public void visitJoinNode(JoinNode node) {
        this.makeNode(node, "JoinNode", "TupleSource", this.format(node.getCommonDeclarations(), "common") + ReflectiveVisitor.newline + this.format(node.getTupleDeclarations(), "tuple"));
        TupleSink nextNode = node.getTupleSink();
        this.makeEdge(node, nextNode);
        this.visitNode(nextNode);
    }

    public void visitTerminalNode(TerminalNode node) {
        this.makeNode(node, "TerminalNode", "TupleSink", "rule: " + node.getRule().getName());
    }

    private void visitNode(Object node) {
        if (!this.visitedNodes.contains(ReteooDotDumpVisitor.dotId(node))) {
            this.visitedNodes.add(ReteooDotDumpVisitor.dotId(node));
            this.visit(node);
        }
    }

    private void makeNode(Object object, String type, String label) {
        this.makeNode(object, type, null, label);
    }

    private void makeNode(Object object, String nodeType, String tupleType, String label) {
        this.makeNode(object, nodeType + "@" + ReteooDotDumpVisitor.dotId(object) + ReflectiveVisitor.newline + (null == tupleType ? "" : "(" + tupleType + ")" + ReflectiveVisitor.newline) + label);
    }

    private void makeNode(Object object, String label) {
        this.out.println("    \"" + ReteooDotDumpVisitor.dotId(object) + "\" [label=\"" + ReteooDotDumpVisitor.format(label) + "\"];");
    }

    private void makeEdge(Object fromNode, Object toNode) {
        this.out.println("    \"" + ReteooDotDumpVisitor.dotId(fromNode) + "\" -> \"" + ReteooDotDumpVisitor.dotId(toNode) + "\";");
    }

    private static String dotId(Object object) {
        return Integer.toHexString(System.identityHashCode(object)).toUpperCase();
    }

    private String format(Set declarationSet, String declString) {
        int i;
        if (null == declarationSet || declarationSet.isEmpty()) {
            return "No " + declString + " declarations";
        }
        Declaration[] declarations = declarationSet.toArray(new Declaration[0]);
        StringBuffer label = new StringBuffer();
        int max = declarations.length - 1;
        for (i = 0; i < max; ++i) {
            label.append(declString + "Decl: " + ReteooDotDumpVisitor.format(declarations[i]) + ReflectiveVisitor.newline);
        }
        label.append(declString + "Decl: " + ReteooDotDumpVisitor.format(declarations[i]));
        return label.toString();
    }

    private static String format(Declaration declaration) {
        return null == declaration ? NULL_STRING : declaration.getIdentifier() + " (" + declaration.getObjectType() + ")";
    }

    private static String format(String label) {
        if (null == label) {
            return NULL_STRING;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(label.getBytes())));
        StringBuffer buffer = new StringBuffer();
        try {
            boolean firstLine = true;
            String line = br.readLine();
            while (null != line) {
                if (line.trim().length() != 0) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        buffer.append("\\n");
                    }
                    buffer.append(line);
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error formatting '" + label + "': " + e.getMessage());
        }
        return buffer.toString();
    }
}

