/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.FactHandleList;
import org.drools.rule.Declaration;

class TupleKey
implements Serializable {
    public static final TupleKey EMPTY_KEY = new TupleKey();
    private final FactHandleList handles;

    private TupleKey() {
        this.handles = FactHandleList.EMPTY_LIST;
    }

    public TupleKey(TupleKey left, TupleKey right) {
        this.handles = new FactHandleList(left.handles, right.handles);
    }

    public TupleKey(Declaration declaration, FactHandle handle) {
        this.handles = new FactHandleList(declaration.getIndex(), (FactHandleImpl)handle);
    }

    public String toString() {
        return "[TupleKey: handles=" + this.handles + "]";
    }

    public FactHandle get(Declaration declaration) {
        return this.handles.get(declaration.getIndex());
    }

    public boolean containsFactHandle(FactHandle handle) {
        return this.handles.contains(handle);
    }

    public boolean containsAll(TupleKey that) {
        return this.handles.containsAll(that.handles);
    }

    public FactHandleImpl getMostRecentFact() {
        FactHandleImpl mostRecent = null;
        long currentRecency = Long.MIN_VALUE;
        for (int i = this.handles.length() - 1; i >= 0; --i) {
            long recency;
            FactHandleImpl eachHandle = (FactHandleImpl)this.handles.get(i);
            if (eachHandle == null || (recency = eachHandle.getRecency()) <= currentRecency) continue;
            currentRecency = recency;
            mostRecent = eachHandle;
        }
        return mostRecent;
    }

    public FactHandleImpl getLeastRecentFact() {
        FactHandleImpl leastRecent = null;
        long currentRecency = Long.MAX_VALUE;
        for (int i = this.handles.length() - 1; i >= 0; --i) {
            long recency;
            FactHandleImpl eachHandle = (FactHandleImpl)this.handles.get(i);
            if (eachHandle == null || (recency = eachHandle.getRecency()) >= currentRecency) continue;
            currentRecency = recency;
            leastRecent = eachHandle;
        }
        return leastRecent;
    }

    public Set getDeclarations() {
        return Collections.EMPTY_SET;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (thatObj instanceof TupleKey) {
            return this.handles.equals(((TupleKey)thatObj).handles);
        }
        return false;
    }

    public int hashCode() {
        return this.handles.hashCode();
    }
}

