/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.rule.ApplicationData;
import org.drools.rule.DuplicateRuleNameException;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;
import org.drools.spi.ImportEntry;

public class RuleSet
implements Serializable {
    public static final RuleSet[] EMPTY_ARRAY = new RuleSet[0];
    private String name;
    private String documentation;
    private Set ruleNames;
    private List rules;
    private Set imports;
    private Map applicationData;

    public RuleSet(String name) {
        this.name = name;
        this.ruleNames = new HashSet();
        this.rules = new ArrayList();
        this.imports = new HashSet();
        this.applicationData = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addRule(Rule rule) throws DuplicateRuleNameException, InvalidRuleException {
        rule.checkValidity();
        String name = rule.getName();
        if (this.containsRule(name)) {
            throw new DuplicateRuleNameException(this, this.getRule(name), rule);
        }
        this.ruleNames.add(name);
        rule.setLoadOrder(this.rules.size());
        rule.setImports(this.imports);
        this.rules.add(rule);
    }

    public Rule getRule(String name) {
        Rule[] rules = this.getRules();
        for (int i = 0; i < rules.length; ++i) {
            if (!rules[i].getName().equals(name)) continue;
            return rules[i];
        }
        return null;
    }

    public boolean containsRule(String name) {
        return this.ruleNames.contains(name);
    }

    public Rule[] getRules() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    public void addImport(ImportEntry importEntry) {
        this.imports.add(importEntry);
    }

    public Set getImports() {
        return this.imports;
    }

    public void addApplicationData(ApplicationData applicationData) {
        this.applicationData.put(applicationData.getIdentifier(), applicationData.getType());
    }

    public Map getApplicationData() {
        return this.applicationData;
    }
}

