/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.base;

import java.lang.reflect.Method;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.ObjectType;

public class ClassFieldObjectType
extends ClassObjectType
implements ObjectType {
    private String objectFieldName;
    private String objectFieldValue;
    private Method getterMethod;

    public ClassFieldObjectType(Class objectTypeClass, String fieldName, String fieldValue) {
        super(objectTypeClass);
        this.objectFieldName = fieldName;
        this.objectFieldValue = fieldValue;
    }

    public String getFieldName() {
        return this.objectFieldName;
    }

    public String getFieldValue() {
        return this.objectFieldValue;
    }

    public boolean matches(Object object) {
        if (!this.getType().isInstance(object)) {
            return false;
        }
        if (this.getterMethod == null) {
            String fieldName = this.getFieldName();
            String fieldGetter = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
            try {
                this.getterMethod = this.getType().getMethod(fieldGetter, null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return this.getterMethod.invoke(object, null).equals(this.getFieldValue());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        ClassFieldObjectType thatClassField = (ClassFieldObjectType)thatObj;
        if (thatObj instanceof ClassFieldObjectType) {
            return this.getType().equals(thatClassField.getType()) && this.getFieldName().equals(thatClassField.getFieldName()) && this.getFieldValue().equals(thatClassField.getFieldValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode() ^ this.getFieldName().hashCode() ^ this.getFieldValue().hashCode();
    }

    public String toString() {
        String fieldName = this.getFieldName();
        return this.getType().getName() + ".get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1) + "(\"" + this.getFieldValue() + "\")";
    }
}

