/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.groovy.GroovyImportEntry;
import org.drools.spi.ImportEntry;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Tuple;

public class Interp
implements Serializable {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String text;
    private final Rule rule;
    private transient Script code;

    protected Interp(String text, Rule rule) {
        this.rule = rule;
        this.text = text;
        try {
            StringBuffer newText = new StringBuffer();
            Iterator it = rule.getImports().iterator();
            while (it.hasNext()) {
                ImportEntry importEntry = (ImportEntry)it.next();
                if (!(importEntry instanceof GroovyImportEntry)) continue;
                newText.append("import ");
                newText.append(importEntry.getImportEntry());
                newText.append(";");
                newText.append(LINE_SEPARATOR);
            }
            newText.append(text);
            this.code = this.buildScript(newText.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getText() {
        return this.text;
    }

    protected Script getCode() {
        return this.code;
    }

    protected Rule getRule() {
        return this.rule;
    }

    protected Binding setUpDictionary(Tuple tuple) {
        Binding dict = new Binding();
        Iterator declIter = this.rule.getParameterDeclarations().iterator();
        while (declIter.hasNext()) {
            Declaration eachDecl = (Declaration)declIter.next();
            dict.setVariable(eachDecl.getIdentifier().intern(), tuple.get(eachDecl));
        }
        WorkingMemory workingMemory = tuple.getWorkingMemory();
        dict.setVariable("drools".intern(), (Object)new KnowledgeHelper(this.rule, tuple));
        Map appDataMap = workingMemory.getApplicationDataMap();
        Iterator keyIter = appDataMap.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            Object value = appDataMap.get(key);
            dict.setVariable(key, value);
        }
        return dict;
    }

    private Script buildScript(String text) throws Exception {
        GroovyCodeSource codeSource = new GroovyCodeSource(text, "groovy.script", "groovy.script");
        GroovyClassLoader loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());
        Class clazz = loader.parseClass(codeSource);
        return (Script)clazz.newInstance();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.code = null;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.code = this.buildScript(this.getText());
        }
        catch (Exception e) {
            throw new IOException("Error re-serializing Code Object. Error:" + e.getMessage());
        }
    }
}

