/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.java.Interp;
import org.drools.semantics.java.JavaImportEntry;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.ImportEntry;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Tuple;

public class BlockConsequence
implements Consequence,
Serializable {
    private static final String[] SCRIPT_PARAM_NAMES = new String[]{"tuple", "decls", "drools", "applicationData"};
    private final String block;
    private final Rule rule;
    private final Declaration[] declarations;
    private transient Script script;
    static /* synthetic */ Class class$org$drools$semantics$java$BlockConsequence$Script;

    public BlockConsequence(String block, Rule rule) throws Exception {
        this.block = block;
        this.rule = rule;
        List declarations = rule.getParameterDeclarations();
        this.declarations = declarations.toArray(new Declaration[declarations.size()]);
        this.script = this.compile(rule);
    }

    private void readObject(ObjectInputStream s) throws Exception {
        s.defaultReadObject();
        this.script = this.compile(this.rule);
    }

    public void invoke(Tuple tuple, WorkingMemory workingMemory) throws ConsequenceException {
        try {
            Map applicationData = tuple.getWorkingMemory().getApplicationDataMap();
            this.script.invoke(tuple, this.declarations, new KnowledgeHelper(this.rule, tuple), applicationData);
        }
        catch (Exception e) {
            throw new ConsequenceException(e, this.rule);
        }
    }

    public String getBlock() {
        return this.block;
    }

    private Script compile(Rule rule) throws Exception {
        HashSet<String> imports = new HashSet<String>();
        if (rule.getImports() != null) {
            Iterator it = rule.getImports().iterator();
            while (it.hasNext()) {
                ImportEntry importEntry = (ImportEntry)it.next();
                if (!(importEntry instanceof JavaImportEntry)) continue;
                imports.add(importEntry.getImportEntry());
            }
        }
        return (Script)Interp.compile(rule, class$org$drools$semantics$java$BlockConsequence$Script == null ? (class$org$drools$semantics$java$BlockConsequence$Script = BlockConsequence.class$("org.drools.semantics.java.BlockConsequence$Script")) : class$org$drools$semantics$java$BlockConsequence$Script, this.block, this.block, SCRIPT_PARAM_NAMES, this.declarations, imports, rule.getApplicationData());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Script {
        public void invoke(Tuple var1, Declaration[] var2, KnowledgeHelper var3, Map var4) throws Exception;
    }
}

