/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.java.ExprAnalyzer;
import org.drools.semantics.java.Interp;
import org.drools.semantics.java.JavaImportEntry;
import org.drools.spi.ImportEntry;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Tuple;

public class Expr
implements Serializable {
    private final String originalExpression;
    private final Rule rule;
    private static final String[] SCRIPT_PARAM_NAMES = new String[]{"tuple", "decls", "drools", "applicationData"};
    private final Declaration[] requiredDecls;
    private final String expr;
    private transient ConditionScript conditionScript;
    static /* synthetic */ Class class$org$drools$semantics$java$Expr$ConditionScript;

    protected Expr(String expr, Rule rule) throws Exception {
        this.expr = "return (" + expr + ");";
        this.rule = rule;
        this.originalExpression = expr;
        List requiredDecls = this.analyze(expr, rule.getParameterDeclarations());
        this.requiredDecls = requiredDecls.toArray(new Declaration[requiredDecls.size()]);
        this.conditionScript = this.compile();
    }

    private void readObject(ObjectInputStream s) throws Exception {
        s.defaultReadObject();
        this.conditionScript = this.compile();
    }

    public String getExpression() {
        return this.originalExpression;
    }

    public boolean evaluateCondition(Tuple tuple) throws Exception {
        return this.conditionScript.invoke(tuple, this.requiredDecls, new KnowledgeHelper(this.rule, tuple), tuple.getWorkingMemory().getApplicationDataMap());
    }

    protected List analyze(String expr, List available) throws Exception {
        ExprAnalyzer analyzer = new ExprAnalyzer();
        return analyzer.analyze(expr, available);
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDecls;
    }

    private ConditionScript compile() throws Exception {
        HashSet<String> imports = new HashSet<String>();
        if (this.rule.getImports() != null) {
            Iterator it = this.rule.getImports().iterator();
            while (it.hasNext()) {
                ImportEntry importEntry = (ImportEntry)it.next();
                if (!(importEntry instanceof JavaImportEntry)) continue;
                imports.add(importEntry.getImportEntry());
            }
        }
        return (ConditionScript)Interp.compile(this.rule, class$org$drools$semantics$java$Expr$ConditionScript == null ? (class$org$drools$semantics$java$Expr$ConditionScript = Expr.class$("org.drools.semantics.java.Expr$ConditionScript")) : class$org$drools$semantics$java$Expr$ConditionScript, this.expr, this.originalExpression, SCRIPT_PARAM_NAMES, this.requiredDecls, imports, this.rule.getApplicationData());
    }

    protected Rule getRule() {
        return this.rule;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ConditionScript {
        public boolean invoke(Tuple var1, Declaration[] var2, KnowledgeHelper var3, Map var4) throws Exception;
    }
}

