/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.drools.rule.Declaration;
import org.drools.semantics.java.MissingDeclarationException;
import org.drools.semantics.java.parser.JavaLexer;
import org.drools.semantics.java.parser.JavaRecognizer;
import org.drools.semantics.java.parser.JavaTreeParser;

public class ExprAnalyzer {
    public List analyze(String expr, List availDecls) throws TokenStreamException, RecognitionException, MissingDeclarationException {
        JavaLexer lexer = new JavaLexer(new StringReader(expr));
        JavaRecognizer parser = new JavaRecognizer(lexer);
        parser.ruleCondition();
        AST ast = parser.getAST();
        return this.analyze(availDecls, ast);
    }

    private List analyze(List availDecls, AST ast) throws RecognitionException {
        JavaTreeParser treeParser = new JavaTreeParser();
        treeParser.init();
        treeParser.exprCondition(ast);
        HashSet refs = new HashSet(treeParser.getVariableReferences());
        ArrayList<Declaration> decls = new ArrayList<Declaration>();
        Iterator declIter = availDecls.iterator();
        while (declIter.hasNext()) {
            Declaration eachDecl = (Declaration)declIter.next();
            if (!refs.contains(eachDecl.getIdentifier())) continue;
            decls.add(eachDecl);
            refs.remove(eachDecl.getIdentifier());
        }
        return decls;
    }
}

