/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import net.janino.Scanner;
import org.drools.rule.Rule;
import org.drools.semantics.java.CompilationException;
import org.drools.semantics.java.Expr;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.Tuple;

public class ExprCondition
extends Expr
implements Condition {
    public ExprCondition(String expr, Rule rule) throws Exception {
        super(expr, rule);
    }

    public boolean isAllowed(Tuple tuple) throws ConditionException {
        try {
            return this.evaluateCondition(tuple);
        }
        catch (Scanner.LocatedException e) {
            throw new ConditionException(e, this.getRule(), this.getExpression());
        }
        catch (CompilationException e) {
            System.err.println("[" + e.getText() + "]");
            throw new ConditionException(e.getMessage(), e.getRule(), e.getText());
        }
        catch (Exception e) {
            throw new ConditionException(e, this.getRule(), this.getExpression());
        }
    }

    public String toString() {
        return "[Condition: " + this.getExpression() + "]";
    }
}

