/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.MockTuple;
import org.drools.MockWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.smf.ConditionFactory;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.DefaultSemanticsRepository;
import org.drools.smf.MockConfiguration;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsRepository;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public abstract class SMFTestFrameWork
extends TestCase {
    private List tests;
    private String testType;
    private SemanticModule module;
    private SemanticsRepository repository;
    private String newline = System.getProperty("line.separator");
    private Set imports;
    static /* synthetic */ Class class$org$drools$smf$SMFTestFrameWork$Cheese;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;

    public SMFTestFrameWork(String name) {
        super(name);
        this.testType = name.substring(4).toLowerCase();
    }

    public void setUp(String semantic, Set imports) throws Exception {
        if (!"conditions".equals(this.testType) && !"consequences".equals(this.testType)) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL semanticTests = cl.getResource(semantic + "-" + this.testType + ".data");
        BufferedReader in = new BufferedReader(new InputStreamReader(semanticTests.openStream()));
        StringBuffer buffer = new StringBuffer();
        String blockMarker = "<!--drools-test--!>";
        this.tests = new ArrayList();
        while (in.ready()) {
            String line = in.readLine() + this.newline;
            if (line.startsWith(blockMarker)) {
                this.tests.add(buffer.toString());
                buffer = new StringBuffer();
                continue;
            }
            buffer.append(line);
        }
        this.tests.add(buffer.toString());
        this.repository = DefaultSemanticsRepository.getInstance();
        this.module = this.repository.lookupSemanticModule("http://drools.org/semantics/" + semantic);
        this.imports = imports;
    }

    public void testConditions() throws Exception {
        int testNumber = 0;
        MockConfiguration cheeseConfiguration = new MockConfiguration("test1");
        cheeseConfiguration.setText((class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese).getName());
        ObjectTypeFactory objectTypeFactory = this.module.getObjectTypeFactory("class");
        ObjectType cheeseType = objectTypeFactory.newObjectType(cheeseConfiguration, new HashSet());
        MockTuple tuple = new MockTuple();
        Rule rule = new Rule("Test Rule 1");
        rule.setImports(new HashSet());
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Declaration camembertDecl = rule.addParameterDeclaration("camembert", cheeseType);
        Declaration stiltonDecl = rule.addParameterDeclaration("stilton", cheeseType);
        tuple.put(camembertDecl, new Cheese("camembert"));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        tuple = new MockTuple();
        rule.setImports(new HashSet());
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        tuple.put(stiltonDecl, new Cheese("stilton"));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        tuple = new MockTuple();
        rule.setImports(new HashSet());
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        tuple.put(stiltonDecl, new Cheese("stilton"));
        tuple.put(camembertDecl, new Cheese("camembert"));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        MockWorkingMemory workingMemory = new MockWorkingMemory();
        workingMemory.setApplicationData("bites", new Integer(3));
        workingMemory.setApplicationData("favouriteCheese", new Cheese("camembert"));
        tuple.setWorkingMemory(workingMemory);
        HashMap<String, Class> applicationData = new HashMap<String, Class>();
        applicationData.put("bites", class$java$lang$Integer == null ? (class$java$lang$Integer = SMFTestFrameWork.class$("java.lang.Integer")) : class$java$lang$Integer);
        applicationData.put("favouriteCheese", class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese);
        rule.setApplicationData(applicationData);
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        tuple = new MockTuple();
        rule.setImports(new HashSet());
        rule.setApplicationData(new HashMap());
        tuple.setRule(rule);
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        MockConfiguration stringConfiguration = new MockConfiguration("test2");
        stringConfiguration.setText((class$java$lang$String == null ? (class$java$lang$String = SMFTestFrameWork.class$("java.lang.String")) : class$java$lang$String).getName());
        ObjectType stringType = objectTypeFactory.newObjectType(stringConfiguration, new HashSet());
        Declaration favouriteCheeseDecl = rule.addParameterDeclaration("favouriteCheese", stringType);
        tuple.put(favouriteCheeseDecl, "camembert");
        tuple.put(camembertDecl, new Cheese("camembert"));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        rule.setImports(this.imports);
        tuple.setRule(rule);
        try {
            this.testCondition(testNumber++, tuple, rule);
            Assert.fail((String)"Condition should throw an exception");
        }
        catch (ConditionException e) {
            Assert.assertEquals((Object)rule, (Object)e.getRule());
            Assert.assertEquals(this.tests.get(testNumber - 1), (Object)e.getInfo());
        }
        tuple = new MockTuple();
        rule.setImports(this.imports);
        tuple.setRule(rule);
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
    }

    private boolean testCondition(int testNumber, Tuple tuple, Rule rule) throws Exception {
        ConditionFactory conditionFactory = this.module.getConditionFactory("condition");
        MockConfiguration conditionConfiguration = new MockConfiguration("test" + testNumber);
        conditionConfiguration.setText((String)this.tests.get(testNumber));
        Condition condition = conditionFactory.newCondition(conditionConfiguration, rule);
        return condition.isAllowed(tuple);
    }

    public void testConsequences() throws Exception {
        MockConfiguration cheeseConfiguration = new MockConfiguration("test1");
        cheeseConfiguration.setText((class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese).getName());
        ObjectTypeFactory objectTypeFactory = this.module.getObjectTypeFactory("class");
        ObjectType cheeseType = objectTypeFactory.newObjectType(cheeseConfiguration, null);
        MockTuple tuple = new MockTuple();
        Rule rule = new Rule("Test Rule 1");
        rule.setImports(this.imports);
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        this.testConsequence(0, tuple, rule);
        Declaration camembertDecl = rule.addParameterDeclaration("camembert", cheeseType);
        Declaration stiltonDecl = rule.addParameterDeclaration("stilton", cheeseType);
        Cheese camembert = new Cheese("camembert");
        Cheese stilton = new Cheese("stilton");
        tuple.put(camembertDecl, camembert);
        tuple.put(stiltonDecl, stilton);
        this.testConsequence(1, tuple, rule);
        Assert.assertEquals((int)3, (int)camembert.getBitesLeft());
        Assert.assertEquals((int)3, (int)stilton.getBitesLeft());
        this.testConsequence(2, tuple, rule);
        Assert.assertEquals((int)2, (int)camembert.getBitesLeft());
        Assert.assertEquals((int)1, (int)stilton.getBitesLeft());
        MockWorkingMemory workingMemory = new MockWorkingMemory();
        workingMemory.setApplicationData("bites", new Integer(3));
        workingMemory.setApplicationData("cheeses", new HashMap());
        HashMap<String, Class> applicationData = new HashMap<String, Class>();
        applicationData.put("bites", class$java$lang$Integer == null ? (class$java$lang$Integer = SMFTestFrameWork.class$("java.lang.Integer")) : class$java$lang$Integer);
        applicationData.put("cheeses", class$java$util$HashMap == null ? (class$java$util$HashMap = SMFTestFrameWork.class$("java.util.HashMap")) : class$java$util$HashMap);
        rule.setApplicationData(applicationData);
        tuple.setWorkingMemory(workingMemory);
        this.testConsequence(3, tuple, rule);
        Assert.assertEquals((int)1, (int)camembert.getBitesLeft());
        Assert.assertEquals((int)0, (int)stilton.getBitesLeft());
        Map map = (Map)workingMemory.getApplicationData("cheeses");
        Assert.assertEquals((Object)camembert, map.get("favourite cheese"));
        Assert.assertEquals((int)3, (int)((Integer)map.get("bites")));
        rule = new Rule("Test Rule 1");
        rule.setImports(this.imports);
        tuple.setRule(rule);
        try {
            this.testConsequence(6, tuple, rule);
            Assert.fail((String)"Consequence should throw an exception");
        }
        catch (ConsequenceException e) {
            Assert.assertEquals((Object)rule, (Object)e.getRule());
        }
        tuple = new MockTuple();
        rule = new Rule("Test Rule 1");
        rule.setImports(this.imports);
        tuple.setRule(rule);
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        try {
            this.testConsequence(7, tuple, rule);
        }
        catch (ConsequenceException e) {
            Assert.fail((String)"Consequence should execute without errors");
        }
    }

    private void testConsequence(int testNumber, Tuple tuple, Rule rule) throws Exception {
        ConsequenceFactory consequenceFactory = this.module.getConsequenceFactory("consequence");
        MockConfiguration consequenceConfiguration = new MockConfiguration("test" + testNumber);
        consequenceConfiguration.setText((String)this.tests.get(testNumber));
        Consequence consequence = consequenceFactory.newConsequence(consequenceConfiguration, rule);
        consequence.invoke(tuple, tuple.getWorkingMemory());
    }

    public static boolean conditionExceptionTest() throws Exception {
        throw new Exception("this is a condition exception");
    }

    public static void consequenceExceptionTest() throws Exception {
        throw new Exception("this is a consequence exception");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Cheese {
        private String name;
        private int bitesLeft = 3;

        public Cheese(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void eatCheese() {
            --this.bitesLeft;
        }

        public int getBitesLeft() {
            return this.bitesLeft;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Cheese)) {
                return false;
            }
            Cheese otherCheese = (Cheese)object;
            return this.name.equals(otherCheese.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

