/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.drools.smf.ApplicationDataFactory;
import org.drools.smf.ConditionFactory;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.DurationFactory;
import org.drools.smf.ImportEntryFactory;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.RuleFactory;
import org.drools.smf.SemanticModule;
import org.drools.smf.SimpleSemanticModule;

public class SemanticsReader {
    private static final SemanticsReader INSTANCE = new SemanticsReader();
    static /* synthetic */ Class class$org$drools$smf$SemanticsReader;

    public static SemanticsReader getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SemanticModule read(URL url) throws Exception {
        InputStream in = url.openStream();
        try {
            SemanticModule semanticModule = this.read(in);
            return semanticModule;
        }
        finally {
            in.close();
        }
    }

    public SemanticModule read(InputStream in) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$org$drools$smf$SemanticsReader == null ? (class$org$drools$smf$SemanticsReader = SemanticsReader.class$("org.drools.smf.SemanticsReader")) : class$org$drools$smf$SemanticsReader).getClassLoader();
        }
        Properties props = new Properties();
        props.load(in);
        String uri = props.getProperty("module.uri");
        if (uri == null || uri.trim().equals("")) {
            throw new Exception("module.uri must be specified");
        }
        SimpleSemanticModule module = new SimpleSemanticModule(uri.trim());
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            Object factory;
            String key = (String)propNames.nextElement();
            if (key.equals("module.uri")) continue;
            String className = props.getProperty(key);
            Class<?> factoryClass = cl.loadClass(className);
            if (key.indexOf("(") < 0 || key.indexOf(")") < 0) {
                throw new Exception("invalid key: " + key);
            }
            String type = this.parseType(key);
            if (type == null || type.equals("")) {
                throw new Exception("no type specified");
            }
            String componentName = this.parseName(key);
            if (componentName == null || componentName.equals("")) {
                throw new Exception("no component name specified");
            }
            if ("Rule".equals(type)) {
                factory = (RuleFactory)factoryClass.newInstance();
                module.addRuleFactory(componentName, (RuleFactory)factory);
                continue;
            }
            if ("ObjectType".equals(type)) {
                factory = (ObjectTypeFactory)factoryClass.newInstance();
                module.addObjectTypeFactory(componentName, (ObjectTypeFactory)factory);
                continue;
            }
            if ("Condition".equals(type)) {
                factory = (ConditionFactory)factoryClass.newInstance();
                module.addConditionFactory(componentName, (ConditionFactory)factory);
                continue;
            }
            if ("Consequence".equals(type)) {
                factory = (ConsequenceFactory)factoryClass.newInstance();
                module.addConsequenceFactory(componentName, (ConsequenceFactory)factory);
                continue;
            }
            if ("Duration".equals(type)) {
                factory = (DurationFactory)factoryClass.newInstance();
                module.addDurationFactory(componentName, (DurationFactory)factory);
                continue;
            }
            if ("ImportEntry".equals(type)) {
                factory = (ImportEntryFactory)factoryClass.newInstance();
                module.addImportEntryFactory(componentName, (ImportEntryFactory)factory);
                continue;
            }
            if ("ApplicationData".equals(type)) {
                factory = (ApplicationDataFactory)factoryClass.newInstance();
                module.addApplicationDataFactory(componentName, (ApplicationDataFactory)factory);
                continue;
            }
            throw new Exception("unknown type '" + type + "'");
        }
        return module;
    }

    protected String parseType(String key) {
        int leftParen = key.indexOf("(");
        if (leftParen < 0) {
            return null;
        }
        return key.substring(0, leftParen).trim();
    }

    protected String parseName(String key) {
        int leftParen = key.indexOf("(");
        int rightParen = key.indexOf(")");
        if (leftParen < 0 || rightParen < 0) {
            return null;
        }
        return key.substring(leftParen + 1, rightParen).trim();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

