/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.PrintStream;
import java.io.PrintWriter;

public class DroolsException
extends Exception {
    private final Throwable rootCause;

    public DroolsException() {
        this.rootCause = null;
    }

    public DroolsException(String msg) {
        super(msg);
        this.rootCause = null;
    }

    public DroolsException(Throwable rootCause) {
        this.rootCause = rootCause;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getMessage() {
        Throwable rootCause;
        String selfMessage = super.getMessage();
        StringBuffer msg = new StringBuffer();
        if (selfMessage != null) {
            msg.append(selfMessage);
        }
        if ((rootCause = this.getRootCause()) != null) {
            if (selfMessage != null) {
                msg.append(" : ");
            }
            msg.append(rootCause.getMessage());
        }
        if (msg.length() > 0) {
            return msg.toString();
        }
        return null;
    }

    public String getLocalizedMessage() {
        StringBuffer msg = new StringBuffer();
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            msg.append(rootCause.getLocalizedMessage());
        } else {
            msg.append(super.getLocalizedMessage());
        }
        if (msg.length() > 0) {
            return msg.toString();
        }
        return null;
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            System.err.println("Nested exception was: ");
            rootCause.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            System.err.println("Nested exception was: ");
            rootCause.printStackTrace(s);
        }
    }
}

