/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.drools.io.ApplicationDataHandler;
import org.drools.io.ConditionHandler;
import org.drools.io.ConsequenceHandler;
import org.drools.io.DefaultConfiguration;
import org.drools.io.DurationHandler;
import org.drools.io.FunctionsHandler;
import org.drools.io.Handler;
import org.drools.io.ImportHandler;
import org.drools.io.ObjectTypeHandler;
import org.drools.io.ParameterHandler;
import org.drools.io.RuleHandler;
import org.drools.io.RuleSetHandler;
import org.drools.rule.RuleSet;
import org.drools.smf.Configuration;
import org.drools.smf.DefaultSemanticsRepository;
import org.drools.smf.NoSuchSemanticModuleException;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsRepository;
import org.drools.spi.RuleBaseContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RuleSetReader
extends DefaultHandler {
    public static final String RULES_NAMESPACE_URI = "http://drools.org/rules";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private SAXParser parser;
    private Locator locator;
    private SemanticsRepository repo;
    private LinkedList configurationStack;
    private StringBuffer characters2;
    private Map localNameMap;
    private boolean lastWasEndElement;
    private LinkedList parents;
    private Object peer;
    private Object current;
    private RuleSet ruleSet;
    private RuleBaseContext factoryContext;
    private MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");
    static /* synthetic */ Class class$org$drools$io$RuleSetReader;

    public RuleSetReader() {
        this.configurationStack = new LinkedList();
        this.parents = new LinkedList();
        this.localNameMap = new HashMap();
        this.localNameMap.put("rule-set", new RuleSetHandler(this));
        this.localNameMap.put("import", new ImportHandler(this));
        this.localNameMap.put("application-data", new ApplicationDataHandler(this));
        this.localNameMap.put("functions", new FunctionsHandler(this));
        this.localNameMap.put("rule", new RuleHandler(this));
        this.localNameMap.put("parameter", new ParameterHandler(this));
        this.localNameMap.put("class", new ObjectTypeHandler(this));
        this.localNameMap.put("class-field", new ObjectTypeHandler(this));
        this.localNameMap.put("semaphore", new ObjectTypeHandler(this));
        this.localNameMap.put("condition", new ConditionHandler(this));
        this.localNameMap.put("duration", new DurationHandler(this));
        this.localNameMap.put("consequence", new ConsequenceHandler(this));
    }

    public RuleSetReader(SAXParser parser) {
        this();
        this.parser = parser;
    }

    public RuleSetReader(SemanticsRepository repo) {
        this();
        this.repo = repo;
    }

    public RuleSetReader(RuleBaseContext factoryContext) {
        this();
        this.factoryContext = factoryContext;
    }

    public RuleSetReader(SemanticsRepository repo, SAXParser parser) {
        this(parser);
        this.repo = repo;
    }

    public RuleSetReader(SemanticsRepository repo, RuleBaseContext context) {
        this();
        this.repo = repo;
        this.factoryContext = context;
    }

    public RuleSetReader(SAXParser parser, SemanticsRepository repo) {
        this();
        this.parser = parser;
        this.repo = repo;
    }

    public RuleSetReader(SAXParser parser, RuleBaseContext context) {
        this();
        this.parser = parser;
        this.factoryContext = context;
    }

    public RuleSetReader(SemanticsRepository repo, SAXParser parser, RuleBaseContext context) {
        this(parser);
        this.repo = repo;
        this.factoryContext = context;
    }

    public RuleSet read(URL url) throws SAXException, IOException {
        return this.read(new InputSource(url.toExternalForm()));
    }

    public RuleSet read(Reader reader) throws SAXException, IOException {
        return this.read(new InputSource(reader));
    }

    public RuleSet read(InputStream inputStream) throws SAXException, IOException {
        return this.read(new InputSource(inputStream));
    }

    public RuleSet read(String url) throws SAXException, IOException {
        return this.read(new InputSource(url));
    }

    public RuleSet read(InputSource in) throws SAXException, IOException {
        SAXParser parser;
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            String isValidating = System.getProperty("drools.schema.validating");
            if (isValidating == null) {
                isValidating = "true";
            }
            factory.setValidating(Boolean.valueOf(isValidating));
            try {
                parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e.getMessage());
            }
            try {
                parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (SAXNotRecognizedException e) {
                System.err.println("Your SAX parser is not JAXP 1.2 compliant.");
            }
        } else {
            parser = this.parser;
        }
        if (!parser.isNamespaceAware()) {
            throw new RuntimeException("parser must be namespace-aware");
        }
        if (this.repo == null) {
            try {
                this.repo = DefaultSemanticsRepository.getInstance();
            }
            catch (Exception e) {
                throw new SAXException("Unable to reference a Semantics Repository");
            }
        }
        parser.parse(in, (DefaultHandler)this);
        return this.ruleSet;
    }

    public SemanticsRepository getSemanticsRepository() {
        return this.repo;
    }

    void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public RuleBaseContext getFactoryContext() {
        return this.factoryContext;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void startDocument() {
        this.ruleSet = null;
        this.current = null;
        this.peer = null;
        this.lastWasEndElement = false;
        this.parents.clear();
        this.characters2 = null;
        this.configurationStack.clear();
        if (this.factoryContext == null) {
            this.factoryContext = new RuleBaseContext();
        }
    }

    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if (!this.lastWasEndElement) {
            this.peer = null;
        }
        Handler handler = this.getHandler(localName);
        this.validate(localName, handler);
        Object node = handler.start(uri, localName, attrs);
        if (node != null) {
            this.parents.add(node);
            this.current = node;
        }
        this.lastWasEndElement = false;
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        Handler handler = this.getHandler(localName);
        this.current = this.getParent(handler.generateNodeFor());
        Object node = handler.end(uri, localName);
        if (node != null && !this.lastWasEndElement) {
            this.peer = node;
        } else if (this.lastWasEndElement || this.parents.getLast().getClass().isInstance(this.current)) {
            this.peer = this.parents.removeLast();
        }
        this.lastWasEndElement = true;
    }

    private void validate(String localName, Handler handler) throws SAXParseException {
        boolean validParent = false;
        boolean validPeer = false;
        boolean invalidNesting = false;
        Set validParents = handler.getValidParents();
        Set validPeers = handler.getValidPeers();
        boolean allowNesting = handler.allowNesting();
        Object parent = this.parents.size() != 0 ? this.parents.getLast() : null;
        Class nodeClass = this.getHandler(localName).generateNodeFor();
        if (!nodeClass.isInstance(parent)) {
            Iterator it = validParents.iterator();
            while (!validParent && it.hasNext()) {
                Object allowedParent = it.next();
                if (parent == null && allowedParent == null) {
                    validParent = true;
                    continue;
                }
                if (allowedParent == null || !((Class)allowedParent).isInstance(parent)) continue;
                validParent = true;
            }
            if (!validParent) {
                throw new SAXParseException("<" + localName + "> has an invalid parent element", this.getLocator());
            }
        }
        Object peer = this.peer;
        Iterator it = validPeers.iterator();
        while (!validPeer && it.hasNext()) {
            Object allowedPeer = it.next();
            if (peer == null && allowedPeer == null) {
                validPeer = true;
                continue;
            }
            if (allowedPeer == null || !((Class)allowedPeer).isInstance(peer)) continue;
            validPeer = true;
        }
        if (!validPeer) {
            throw new SAXParseException("<" + localName + "> is after an invalid element", this.getLocator());
        }
        if (!allowNesting) {
            it = this.parents.iterator();
            while (!invalidNesting && it.hasNext()) {
                if (!nodeClass.isInstance(it.next())) continue;
                invalidNesting = true;
            }
        }
        if (invalidNesting) {
            throw new SAXParseException("<" + localName + ">  may not be nested", this.getLocator());
        }
    }

    protected void startConfiguration(String name, Attributes attrs) {
        this.characters2 = new StringBuffer();
        DefaultConfiguration config = new DefaultConfiguration(name);
        int numAttrs = attrs.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            config.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
        }
        if (this.configurationStack.isEmpty()) {
            this.configurationStack.addLast(config);
        } else {
            ((DefaultConfiguration)this.configurationStack.getLast()).addChild(config);
        }
    }

    public void characters(char[] chars, int start, int len) {
        if (this.characters2 != null) {
            this.characters2.append(chars, start, len);
        }
    }

    protected Configuration endConfiguration() {
        DefaultConfiguration config = (DefaultConfiguration)this.configurationStack.removeLast();
        config.setText(this.characters2.toString());
        this.characters2 = null;
        return config;
    }

    SemanticModule lookupSemanticModule(String uri, String localName) throws SAXParseException {
        SemanticModule module;
        try {
            module = this.repo.lookupSemanticModule(uri);
        }
        catch (NoSuchSemanticModuleException e) {
            throw new SAXParseException("no semantic module for namespace '" + uri + "' (" + localName + ")", this.getLocator());
        }
        return module;
    }

    private Handler getHandler(String localName) throws SAXParseException {
        Handler handler = (Handler)this.localNameMap.get(localName);
        if (handler == null) {
            throw new SAXParseException("unable to handle element <" + localName + ">", this.getLocator());
        }
        return handler;
    }

    LinkedList getParents() {
        return this.parents;
    }

    Object getParent(Class parent) {
        ListIterator it = this.parents.listIterator(this.parents.size());
        Object node = null;
        while (it.hasPrevious() && !parent.isInstance(node = it.previous())) {
        }
        return node;
    }

    Object getPeer() {
        return this.peer;
    }

    Object getCurrent() {
        return this.current;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (!systemId.toLowerCase().endsWith("xsd")) {
            return null;
        }
        try {
            URL url = new URL(systemId);
            return new InputSource(url.openStream());
        }
        catch (Exception e) {
            int index = systemId.lastIndexOf("/");
            if (index == -1) {
                index = systemId.lastIndexOf("\\");
            }
            String xsd = index != -1 ? systemId.substring(index + 1) : systemId;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = (class$org$drools$io$RuleSetReader == null ? (class$org$drools$io$RuleSetReader = RuleSetReader.class$("org.drools.io.RuleSetReader")) : class$org$drools$io$RuleSetReader).getClassLoader();
            }
            try {
                return new InputSource(cl.getResourceAsStream("META-INF/" + xsd));
            }
            catch (Exception e2) {
                try {
                    return new InputSource(cl.getResourceAsStream("/META-INF/" + xsd));
                }
                catch (Exception e3) {
                    try {
                        return new InputSource(cl.getResourceAsStream("/" + xsd));
                    }
                    catch (Exception e4) {
                        try {
                            return new InputSource(new BufferedInputStream(new FileInputStream(xsd)));
                        }
                        catch (Exception e5) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    private void print(SAXParseException x) {
        String msg = this.message.format(new Object[]{x.getSystemId(), new Integer(x.getLineNumber()), new Integer(x.getColumnNumber()), x.getMessage()});
        System.out.println(msg);
    }

    public void warning(SAXParseException x) {
        this.print(x);
    }

    public void error(SAXParseException x) {
        this.print(x);
    }

    public void fatalError(SAXParseException x) throws SAXParseException {
        this.print(x);
        throw x;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

