/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.reteoo.AgendaItem;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.Scheduler;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Rule;
import org.drools.spi.AgendaFilter;
import org.drools.spi.ConflictResolver;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Duration;
import org.drools.spi.Tuple;
import org.drools.util.PriorityQueue;

class Agenda
implements Serializable {
    private final WorkingMemoryImpl workingMemory;
    private final PriorityQueue items;
    private final Set scheduledItems;
    private AgendaItem item;

    public Agenda(WorkingMemoryImpl workingMemory, ConflictResolver conflictResolver) {
        this.workingMemory = workingMemory;
        this.items = new PriorityQueue(conflictResolver);
        this.scheduledItems = new HashSet();
    }

    void addToAgenda(ReteTuple tuple, Rule rule) {
        if (rule == null) {
            return;
        }
        if (this.item != null && rule.getNoLoop() && rule.equals(this.item.getRule())) {
            return;
        }
        AgendaItem item = new AgendaItem(tuple, rule);
        Duration dur = rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            this.scheduledItems.add(item);
            this.scheduleItem(item);
        } else {
            this.items.add(item);
        }
        this.workingMemory.getEventSupport().fireActivationCreated(rule, tuple);
    }

    void removeFromAgenda(TupleKey key, Rule rule) {
        Tuple tuple;
        AgendaItem eachItem;
        if (rule == null) {
            return;
        }
        Iterator itemIter = this.items.iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            tuple = eachItem.getTuple();
            itemIter.remove();
            itemIter = this.items.iterator();
            this.workingMemory.getEventSupport().fireActivationCancelled(rule, tuple);
        }
        itemIter = this.scheduledItems.iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            tuple = eachItem.getTuple();
            this.cancelItem(eachItem);
            itemIter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(rule, tuple);
        }
    }

    void modifyAgenda(FactHandle trigger, TupleSet modifyTuples, Rule rule) {
        AgendaItem eachItem;
        Iterator itemIter = this.items.iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.dependsOn(trigger)) continue;
            modifyTuples.removeTuple(eachItem.getKey());
        }
        itemIter = this.scheduledItems.iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.dependsOn(trigger)) continue;
            modifyTuples.removeTuple(eachItem.getKey());
        }
        Iterator tupleIter = modifyTuples.iterator();
        while (tupleIter.hasNext()) {
            ReteTuple eachTuple = (ReteTuple)tupleIter.next();
            this.addToAgenda(eachTuple, rule);
        }
    }

    void clearAgenda() {
        AgendaItem eachItem;
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            eachItem = (AgendaItem)iter.next();
            iter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
        }
        iter = this.scheduledItems.iterator();
        while (iter.hasNext()) {
            eachItem = (AgendaItem)iter.next();
            this.cancelItem(eachItem);
            iter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
        }
    }

    void scheduleItem(AgendaItem item) {
        Scheduler.getInstance().scheduleAgendaItem(item, this.workingMemory);
    }

    void cancelItem(AgendaItem item) {
        Scheduler.getInstance().cancelAgendaItem(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int size() {
        return this.items.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNextItem(AgendaFilter filter) throws ConsequenceException {
        if (this.isEmpty()) {
            return;
        }
        this.item = (AgendaItem)this.items.remove();
        try {
            if (filter == null || filter.accept(this.item)) {
                this.item.fire(this.workingMemory);
            }
        }
        finally {
            this.item = null;
        }
    }
}

