/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collections;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Declaration;

class ParameterNode
extends TupleSource {
    private final ObjectTypeNode objectTypeNode;
    private final Declaration declaration;
    private final Set declarations;

    public ParameterNode(ObjectTypeNode objectTypeNode, Declaration declaration) {
        this.objectTypeNode = objectTypeNode;
        this.declaration = declaration;
        this.declarations = Collections.singleton(declaration);
    }

    public void attach() {
        this.objectTypeNode.addParameterNode(this);
    }

    void assertObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws AssertionException {
        ReteTuple tuple = new ReteTuple(workingMemory, this.getDeclaration(), handle);
        this.propagateAssertTuple(tuple, workingMemory);
    }

    void retractObject(FactHandle handle, WorkingMemoryImpl workingMemory) throws RetractionException {
        TupleKey key = new TupleKey(this.getDeclaration(), handle);
        this.propagateRetractTuples(key, workingMemory);
    }

    void modifyObject(FactHandle handle, Object newObject, WorkingMemoryImpl workingMemory) throws FactException {
        ReteTuple tuple = new ReteTuple(workingMemory, this.getDeclaration(), handle);
        this.propagateModifyTuples(handle, new TupleSet(tuple), workingMemory);
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public Set getTupleDeclarations() {
        return this.declarations;
    }

    public int hashCode() {
        return this.declaration.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.declaration.equals(((ParameterNode)object).declaration);
    }
}

