/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.PrintStream;
import java.util.Iterator;
import org.drools.RuleBase;
import org.drools.reteoo.ConditionNode;
import org.drools.reteoo.JoinNodeInput;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.ReflectiveVisitor;
import org.drools.reteoo.Rete;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.reteoo.TerminalNode;
import org.drools.rule.Declaration;

public class ReteooPrintDumpVisitor
extends ReflectiveVisitor {
    private PrintStream out;
    private StringBuffer buffer;
    private int depth;
    private String indent;

    public ReteooPrintDumpVisitor(PrintStream out) {
        this.out = out;
        this.indent = "  ";
    }

    public ReteooPrintDumpVisitor(PrintStream out, String indent) {
        this.out = out;
        this.indent = indent;
    }

    public void visitRuleBase(RuleBase ruleBase) {
        this.buffer = new StringBuffer();
        this.visit(((RuleBaseImpl)ruleBase).getRete());
        this.out.println(this.buffer.toString());
    }

    public void visitRete(Rete rete) {
        this.buffer.append("Rete");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append("----");
        this.buffer.append(ReflectiveVisitor.newline);
        Iterator it = rete.getObjectTypeNodeIterator();
        int scopedDepth = this.depth++;
        while (it.hasNext()) {
            this.visit(it.next());
        }
        this.depth = scopedDepth;
    }

    public void visitObjectTypeNode(ObjectTypeNode objectTypeNode) {
        String indent = this.getIndent(this.depth);
        this.buffer.append(indent).append("ObjectTypeNode");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("--------------");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("objectType: " + objectTypeNode.getObjectType().toString());
        this.buffer.append(ReflectiveVisitor.newline);
        Iterator it = objectTypeNode.getParameterNodeIterator();
        int scopedDepth = this.depth++;
        while (it.hasNext()) {
            this.visit(it.next());
        }
        this.depth = scopedDepth;
    }

    public void visitParameterNode(ParameterNode parameterNode) {
        String indent = this.getIndent(this.depth);
        this.buffer.append(indent).append("ParameterNode");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("-------------");
        this.buffer.append(ReflectiveVisitor.newline);
        int scopedDepth = this.depth++;
        this.visit(parameterNode.getDeclaration());
        this.buffer.append(indent).append("tupleSink:");
        this.buffer.append(ReflectiveVisitor.newline);
        Iterator it = parameterNode.getTupleSinks().iterator();
        ++this.depth;
        while (it.hasNext()) {
            this.visit(it.next());
        }
        this.depth = scopedDepth;
    }

    public void visitDeclaration(Declaration declaration) {
        String indent = this.getIndent(this.depth);
        this.buffer.append(indent).append("Declaration");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("-----------");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("identifier: ");
        this.buffer.append(declaration.getIdentifier());
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("objectType: ");
        this.buffer.append(declaration.getObjectType());
        this.buffer.append(ReflectiveVisitor.newline);
    }

    public void visitConditionNode(ConditionNode conditionNode) {
        String indent = this.getIndent(this.depth);
        this.buffer.append(indent).append("ConditionNode");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("-------------");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("condition: ");
        this.buffer.append(conditionNode.toString());
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("tupleSink:");
        this.buffer.append(ReflectiveVisitor.newline);
        int scopedDepth = this.depth++;
        Iterator it = conditionNode.getTupleSinks().iterator();
        while (it.hasNext()) {
            this.visit(it.next());
        }
        this.depth = scopedDepth;
    }

    public void visitJoinNodeInput(JoinNodeInput joinNodeInput) {
        String indent = this.getIndent(this.depth);
        this.buffer.append(indent).append("JoinNodeInput");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("-------------");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append(joinNodeInput.toString());
        this.buffer.append(ReflectiveVisitor.newline);
        int scopedDepth = this.depth++;
        Iterator it = joinNodeInput.getJoinNode().getTupleSinks().iterator();
        while (it.hasNext()) {
            this.visit(it.next());
        }
        this.depth = scopedDepth;
    }

    public void visitTerminalNode(TerminalNode terminalNode) {
        String indent = this.getIndent(this.depth);
        this.buffer.append(indent).append("TerminalNode");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append("-------------");
        this.buffer.append(ReflectiveVisitor.newline);
        this.buffer.append(indent).append(terminalNode.toString());
        this.buffer.append(ReflectiveVisitor.newline);
    }

    public void visitObject(Object object) {
        this.buffer.append("no visitor implementation for : " + object.getClass() + " : " + object);
        this.buffer.append(ReflectiveVisitor.newline);
    }

    public void visitNull() {
        this.buffer.append("unable to visit null objects");
        this.buffer.append(ReflectiveVisitor.newline);
    }

    private String getIndent(int depth) {
        StringBuffer indentBuffer = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            indentBuffer.append(this.indent);
        }
        return indentBuffer.toString();
    }
}

