/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.drools.reteoo.AgendaItem;
import org.drools.reteoo.AgendaItemFireListener;
import org.drools.reteoo.WorkingMemoryImpl;

final class Scheduler {
    private static final Scheduler INSTANCE = new Scheduler();
    private Timer scheduler = new Timer(true);
    private Map tasks = new HashMap();

    static Scheduler getInstance() {
        return INSTANCE;
    }

    private Scheduler() {
    }

    void scheduleAgendaItem(AgendaItem item, WorkingMemoryImpl workingMemory) {
        Date now = new Date();
        Date then = new Date(now.getTime() + item.getRule().getDuration().getDuration(item.getTuple()) * 1000L);
        try {
            AgendaItemFireListener task = new AgendaItemFireListener(item, workingMemory);
            this.scheduler.schedule((TimerTask)task, then);
            this.tasks.put(item, task);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void cancelAgendaItem(AgendaItem item) {
        TimerTask task = (TimerTask)this.tasks.get(item);
        if (task != null) {
            task.cancel();
        }
    }
}

