/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.WorkingMemoryImpl;

abstract class TupleSource
implements Serializable {
    private List tupleSinks = new ArrayList(1);

    TupleSource() {
    }

    protected void addTupleSink(TupleSink tupleSink) {
        if (!this.tupleSinks.contains(tupleSink)) {
            this.tupleSinks.add(tupleSink);
        }
    }

    protected void propagateAssertTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        int size = this.tupleSinks.size();
        for (int i = 0; i < size; ++i) {
            ((TupleSink)this.tupleSinks.get(i)).assertTuple(tuple, workingMemory);
        }
    }

    protected void propagateRetractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        int size = this.tupleSinks.size();
        for (int i = 0; i < size; ++i) {
            ((TupleSink)this.tupleSinks.get(i)).retractTuples(key, workingMemory);
        }
    }

    protected void propagateModifyTuples(FactHandle trigger, TupleSet modifyTuples, WorkingMemoryImpl workingMemory) throws FactException {
        int size = this.tupleSinks.size();
        for (int i = 0; i < size; ++i) {
            ((TupleSink)this.tupleSinks.get(i)).modifyTuples(trigger, modifyTuples, workingMemory);
        }
    }

    public List getTupleSinks() {
        return this.tupleSinks;
    }

    public abstract Set getTupleDeclarations();

    public abstract void attach();
}

