/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.ObjectType;

public class ClassFieldObjectType
extends ClassObjectType
implements ObjectType {
    private String objectFieldName;
    private String objectFieldValue;
    private Method getterMethod;

    public ClassFieldObjectType(Class objectTypeClass, String fieldName, String fieldValue) {
        super(objectTypeClass);
        this.objectFieldName = fieldName;
        this.objectFieldValue = fieldValue;
    }

    public String getFieldName() {
        return this.objectFieldName;
    }

    public String getFieldValue() {
        return this.objectFieldValue;
    }

    public boolean matches(Object object) {
        boolean result;
        if (!this.getType().isInstance(object)) {
            return false;
        }
        if (this.getterMethod == null) {
            String fieldName = this.getFieldName();
            String fieldGetter = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
            try {
                this.getterMethod = this.getType().getMethod(fieldGetter, null);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        try {
            result = this.getterMethod.invoke(object, null).equals(this.getFieldValue());
        }
        catch (IllegalAccessException e) {
            result = false;
        }
        catch (InvocationTargetException e) {
            result = false;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClassFieldObjectType other = (ClassFieldObjectType)object;
        return this.getType().equals(other.getType()) && this.getFieldName().equals(other.getFieldName()) && this.getFieldValue().equals(other.getFieldValue());
    }

    public int hashCode() {
        return this.getType().hashCode() ^ this.getFieldName().hashCode() ^ this.getFieldValue().hashCode();
    }

    public String toString() {
        String fieldName = this.getFieldName();
        return this.getType().getName() + ".get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1) + "(\"" + this.getFieldValue() + "\")";
    }
}

