/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.base;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.rule.ApplicationData;
import org.drools.rule.RuleSet;
import org.drools.smf.ApplicationDataFactory;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.spi.ImportEntry;
import org.drools.spi.RuleBaseContext;

public class DefaultApplicationDataFactory
implements ApplicationDataFactory {
    public ApplicationData newApplicationData(RuleSet ruleSet, RuleBaseContext context, Configuration config, Set imports) throws FactoryException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class clazz = null;
        String className = config.getText().trim();
        try {
            clazz = cl.loadClass(className);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == clazz) {
            Iterator it;
            HashSet<String> importSet = new HashSet<String>();
            if (imports != null) {
                it = imports.iterator();
                while (it.hasNext()) {
                    ImportEntry importEntry = (ImportEntry)it.next();
                    importSet.add(importEntry.getImportEntry());
                }
            }
            if (clazz == null) {
                it = importSet.iterator();
                while (it.hasNext() && clazz == null) {
                    clazz = this.importClass(cl, (String)it.next(), className);
                }
            }
        }
        if (null == clazz) {
            throw new FactoryException("Cannot find class [" + className + "] for application data identifier [" + config.getAttribute("identifier") + "]");
        }
        return new ApplicationData(ruleSet, config.getAttribute("identifier"), clazz);
    }

    private Class importClass(ClassLoader cl, String importText, String className) {
        String qualifiedClass = null;
        Class<?> clazz = null;
        if (importText.startsWith("from ")) {
            importText = this.converPythonImport(importText);
        }
        if (importText.endsWith("*")) {
            qualifiedClass = importText.substring(0, importText.indexOf(42)) + className;
        } else if (importText.endsWith(className)) {
            qualifiedClass = importText;
        }
        if (qualifiedClass != null) {
            try {
                clazz = cl.loadClass(qualifiedClass);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return clazz;
    }

    private String converPythonImport(String packageText) {
        int fromIndex = packageText.indexOf("from ");
        int importIndex = packageText.indexOf("import ");
        return packageText.substring(fromIndex + 5, importIndex).trim() + "." + packageText.substring(importIndex + 7).trim();
    }
}

