/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.benchmarks.manners;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.DroolsException;
import org.drools.FactException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.conflict.ComplexityConflictResolver;
import org.drools.examples.benchmarks.manners.MannersWMEL;
import org.drools.examples.benchmarks.manners.model.Context;
import org.drools.examples.benchmarks.manners.model.Count;
import org.drools.examples.benchmarks.manners.model.Guest;
import org.drools.examples.benchmarks.manners.model.LastSeat;
import org.drools.io.RuleBaseLoader;
import org.drools.reteoo.Dumper;
import org.xml.sax.SAXException;

public class MannersBenchmark {
    private static final String DRL_FILE = "manners.drl";
    private static final String DOT_FILE = "manners.dot";
    private List inputObjects;
    private WorkingMemory workingMemory;
    static /* synthetic */ Class class$org$drools$examples$benchmarks$manners$MannersBenchmark;

    public static void main(String[] args) throws DroolsException, IOException, SAXException {
        String datFile = "manners_16.dat";
        if (args.length > 0) {
            datFile = args[0];
        }
        MannersBenchmark benchmark = new MannersBenchmark(datFile);
        long start = System.currentTimeMillis();
        benchmark.run();
        System.out.println("Elapsed time: " + (System.currentTimeMillis() - start) + " ms");
    }

    public MannersBenchmark(String datFile) throws DroolsException, IOException, SAXException {
        System.out.println("Loading DRL: manners.drl...");
        RuleBase ruleBase = RuleBaseLoader.loadFromUrl((class$org$drools$examples$benchmarks$manners$MannersBenchmark == null ? (class$org$drools$examples$benchmarks$manners$MannersBenchmark = MannersBenchmark.class$("org.drools.examples.benchmarks.manners.MannersBenchmark")) : class$org$drools$examples$benchmarks$manners$MannersBenchmark).getResource(DRL_FILE), ComplexityConflictResolver.getInstance());
        File dotFile = new File(DOT_FILE);
        System.out.println("Creating DOT: " + dotFile.getCanonicalPath() + "...");
        new Dumper(ruleBase).dumpReteToDot(new PrintStream(new FileOutputStream(dotFile)));
        this.workingMemory = ruleBase.newWorkingMemory();
        this.workingMemory.addEventListener(new MannersWMEL());
        System.out.println("Reading DAT: " + datFile + "...");
        this.inputObjects = MannersBenchmark.getInputObjects(this.getClass().getResourceAsStream(datFile));
    }

    public void run() throws FactException {
        System.out.println("Asserting initial objects...");
        Iterator i = this.inputObjects.iterator();
        while (i.hasNext()) {
            this.workingMemory.assertObject(i.next());
        }
        System.out.println("Firing all rules...");
        this.workingMemory.fireAllRules();
    }

    private static List getInputObjects(InputStream inputStream) throws IOException {
        String line;
        ArrayList<Object> list = new ArrayList<Object>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith(";")) continue;
            StringTokenizer st = new StringTokenizer(line, "() ");
            String make = st.nextToken();
            if (!"make".equals(make)) {
                throw new IOException("expected 'make' in: " + line);
            }
            String type = st.nextToken();
            if ("guest".equals(type)) {
                if (!"^name".equals(st.nextToken())) {
                    throw new IOException("expected '^name' in: " + line);
                }
                String name = st.nextToken();
                if (!"^sex".equals(st.nextToken())) {
                    throw new IOException("expected '^sex' in: " + line);
                }
                char sex = st.nextToken().charAt(0);
                if (!"^hobby".equals(st.nextToken())) {
                    throw new IOException("expected '^hobby' in: " + line);
                }
                String hobby = st.nextToken();
                list.add(new Guest(name, sex, hobby));
            }
            if ("last_seat".equals(type)) {
                list.add(new LastSeat(Integer.parseInt(st.nextToken())));
            }
            if ("count".equals(type)) {
                list.add(new Count(Integer.parseInt(st.nextToken())));
            }
            if (!"context".equals(type)) continue;
            list.add(new Context(st.nextToken()));
        }
        inputStream.close();
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

