/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.benchmarks.waltz;

import org.drools.examples.benchmarks.waltz.model.Junction;

public class WaltzUtil {
    private static final int MOD_NUM = 100;

    private WaltzUtil() {
    }

    private static int get_x(double val) {
        return (int)(val / 100.0);
    }

    private static int get_y(double val) {
        return (int)(val % 100.0);
    }

    private static double get_angle(int p1, int p2) {
        int delta_x = WaltzUtil.get_x(p2) - WaltzUtil.get_x(p1);
        int delta_y = WaltzUtil.get_y(p2) - WaltzUtil.get_y(p1);
        return Math.atan2(delta_y, delta_x);
    }

    private static double inscribed_angle(int basepoint, int p1, int p2) {
        double angle2;
        double angle1 = WaltzUtil.get_angle(basepoint, p1);
        double temp = angle1 - (angle2 = WaltzUtil.get_angle(basepoint, p2));
        if (temp < 0.0) {
            temp = -temp;
        }
        if (temp > Math.PI) {
            temp = Math.PI * 2 - temp;
        }
        if (temp < 0.0) {
            return -temp;
        }
        return temp;
    }

    public static Junction make_3_junction(int basepoint, int p1, int p2, int p3) {
        int barb2;
        int barb1;
        int shaft;
        double sum;
        double angle12 = WaltzUtil.inscribed_angle(basepoint, p1, p2);
        double angle13 = WaltzUtil.inscribed_angle(basepoint, p1, p3);
        double angle23 = WaltzUtil.inscribed_angle(basepoint, p2, p3);
        double sum1213 = angle12 + angle13;
        double sum1223 = angle12 + angle23;
        double sum1323 = angle13 + angle23;
        if (sum1213 < sum1223) {
            if (sum1213 < sum1323) {
                sum = sum1213;
                shaft = p1;
                barb1 = p2;
                barb2 = p3;
            } else {
                sum = sum1323;
                shaft = p3;
                barb1 = p1;
                barb2 = p2;
            }
        } else if (sum1223 < sum1323) {
            sum = sum1223;
            shaft = p2;
            barb1 = p1;
            barb2 = p3;
        } else {
            sum = sum1323;
            shaft = p3;
            barb1 = p1;
            barb2 = p2;
        }
        double delta = sum - Math.PI;
        if (delta < 0.0) {
            delta = -delta;
        }
        String type = delta < 0.001 ? "tee" : (sum > Math.PI ? "fork" : "arrow");
        return new Junction(barb1, shaft, barb2, basepoint, type);
    }
}

