/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.jiahvac.control.pump;

import org.drools.examples.jiahvac.model.HeatPump;
import org.drools.examples.jiahvac.model.TempuratureControl;
import org.drools.examples.jiahvac.model.Thermometer;
import org.drools.semantics.annotation.DroolsCondition;
import org.drools.semantics.annotation.DroolsConsequence;
import org.drools.semantics.annotation.DroolsParameter;
import org.drools.semantics.annotation.DroolsRule;

@DroolsRule
public class FloorTooColdPumpOff {
    @DroolsCondition
    public boolean isTooCold(@DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="control") TempuratureControl control) {
        return control.isTooCold(thermometer.getReading());
    }

    @DroolsCondition
    public boolean isPumpOff(@DroolsParameter(value="pump") HeatPump pump, @DroolsParameter(value="thermometer") Thermometer thermometer) {
        return pump.getState() == HeatPump.State.OFF && thermometer.getFloor().getHeatPump() == pump;
    }

    @DroolsConsequence
    public void consequence(@DroolsParameter(value="pump") HeatPump pump) {
        pump.setState(HeatPump.State.HEATING);
        System.out.println("FloorTooColdPumpOff: " + pump);
    }
}

