/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.jiahvac.control.pump;

import org.drools.examples.jiahvac.model.Floor;
import org.drools.examples.jiahvac.model.HeatPump;
import org.drools.examples.jiahvac.model.TempuratureControl;
import org.drools.examples.jiahvac.model.Thermometer;
import org.drools.semantics.annotation.DroolsCondition;
import org.drools.semantics.annotation.DroolsConsequence;
import org.drools.semantics.annotation.DroolsParameter;
import org.drools.semantics.annotation.DroolsRule;

@DroolsRule
public class FloorsWarmEnough {
    @DroolsCondition
    public boolean isPumpHeating(@DroolsParameter(value="pump") HeatPump pump) {
        return pump.getState() == HeatPump.State.HEATING;
    }

    @DroolsCondition
    public boolean isAllFloorsWarmEnough(@DroolsParameter(value="pump") HeatPump pump, @DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="control") TempuratureControl control) {
        if (thermometer.getFloor().getHeatPump() != pump) {
            return false;
        }
        boolean result = true;
        for (Floor floor : pump.getFloors()) {
            double temp = floor.getThermometer().getReading();
            result &= control.isWarmEnough(temp);
        }
        return result;
    }

    @DroolsConsequence
    public void consequence(@DroolsParameter(value="pump") HeatPump pump) {
        pump.setState(HeatPump.State.OFF);
        System.out.println("FloorsWarmEnough: " + pump);
    }
}

