/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.jiahvac.control.vent;

import org.drools.examples.jiahvac.model.HeatPump;
import org.drools.examples.jiahvac.model.TempuratureControl;
import org.drools.examples.jiahvac.model.Thermometer;
import org.drools.examples.jiahvac.model.Vent;
import org.drools.semantics.annotation.DroolsCondition;
import org.drools.semantics.annotation.DroolsConsequence;
import org.drools.semantics.annotation.DroolsParameter;
import org.drools.semantics.annotation.DroolsRule;

@DroolsRule
public class CoolingVentClosedFloorTooHot {
    @DroolsCondition
    public boolean condition(@DroolsParameter(value="vent") Vent vent, @DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="pump") HeatPump pump, @DroolsParameter(value="control") TempuratureControl control) {
        return this.isPumpCooling(pump) && this.isVentClosed(vent) && this.isNotCoolEnough(thermometer, control) && this.isSameFloor(vent, thermometer, pump);
    }

    public boolean isPumpCooling(@DroolsParameter(value="pump") HeatPump pump) {
        return pump.getState() == HeatPump.State.COOLING;
    }

    public boolean isVentClosed(@DroolsParameter(value="vent") Vent vent) {
        return vent.getState() == Vent.State.CLOSED;
    }

    public boolean isNotCoolEnough(@DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="control") TempuratureControl control) {
        return !control.isCoolEnough(thermometer.getReading());
    }

    public boolean isSameFloor(@DroolsParameter(value="vent") Vent vent, @DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="pump") HeatPump pump) {
        return vent.getFloor() == thermometer.getFloor() && vent.getFloor().getHeatPump() == pump;
    }

    @DroolsConsequence
    public void consequence(@DroolsParameter(value="vent") Vent vent) {
        vent.setState(Vent.State.OPEN);
        System.out.println("CoolingVentClosedFloorTooHot: " + vent + ", " + vent.getFloor().getThermometer());
    }
}

