/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.jiahvac.sim;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.drools.examples.jiahvac.model.Floor;
import org.drools.examples.jiahvac.model.HeatPump;

public class SimHeatPump
implements HeatPump {
    private final int id;
    private final Floor[] floors;
    private HeatPump.State state = HeatPump.State.OFF;
    private HeatPump.State prevState = HeatPump.State.OFF;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public SimHeatPump(int id, Floor[] floors) {
        this.id = id;
        this.floors = floors;
    }

    public int getId() {
        return this.id;
    }

    public Floor[] getFloors() {
        return this.floors;
    }

    public boolean isServicing(Floor floor) {
        for (Floor servicedFloor : this.floors) {
            if (!floor.equals(servicedFloor)) continue;
            return true;
        }
        return false;
    }

    public HeatPump.State getState() {
        return this.state;
    }

    public void setState(HeatPump.State state) {
        this.state = state;
        this.pcs.firePropertyChange("state", (Object)this.prevState, (Object)state);
        this.prevState = state;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String toString() {
        return "pump(" + this.id + ")=" + (Object)((Object)this.state);
    }
}

