/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.primefactors;

import org.drools.examples.primefactors.Number;
import org.drools.rule.Declaration;
import org.drools.spi.Condition;
import org.drools.spi.Tuple;

public class FactorCondition
implements Condition {
    private final Declaration numberDecl;
    private final int prime;

    public FactorCondition(Declaration numberDecl, int prime) {
        this.numberDecl = numberDecl;
        this.prime = prime;
    }

    public boolean isAllowed(Tuple tuple) {
        return ((Number)tuple.get(this.numberDecl)).getQuotient() % this.prime == 0;
    }

    public Declaration[] getRequiredTupleMembers() {
        return new Declaration[]{this.numberDecl};
    }

    public String toString() {
        return "Divisible by " + this.prime + "?";
    }
}

