/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.drools.IntegrationException;
import org.drools.RuleBase;
import org.drools.RuleBaseBuilder;
import org.drools.conflict.DefaultConflictResolver;
import org.drools.io.RuleSetReader;
import org.drools.rule.RuleSet;
import org.drools.spi.ConflictResolver;
import org.drools.spi.RuleBaseContext;
import org.xml.sax.SAXException;

public final class RuleBaseLoader {
    private RuleBaseLoader() {
        throw new UnsupportedOperationException();
    }

    public static RuleBase loadFromUrl(URL url) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromUrl(url, DefaultConflictResolver.getInstance());
    }

    public static RuleBase loadFromUrl(URL url, ConflictResolver resolver) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromUrl(new URL[]{url}, resolver);
    }

    public static RuleBase loadFromUrl(URL[] urls) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromUrl(urls, DefaultConflictResolver.getInstance());
    }

    public static RuleBase loadFromUrl(URL[] urls, ConflictResolver resolver) throws SAXException, IOException, IntegrationException {
        RuleBaseBuilder builder = new RuleBaseBuilder();
        builder.setConflictResolver(resolver);
        for (int i = 0; i < urls.length; ++i) {
            RuleSetReader reader = new RuleSetReader();
            RuleSet ruleSet = reader.read(urls[i]);
            builder.addRuleSet(ruleSet);
        }
        return builder.build();
    }

    public static RuleBase loadFromInputStream(InputStream in) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromInputStream(in, DefaultConflictResolver.getInstance());
    }

    public static RuleBase loadFromInputStream(InputStream in, ConflictResolver resolver) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromInputStream(new InputStream[]{in}, resolver);
    }

    public static RuleBase loadFromInputStream(InputStream[] ins) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromInputStream(ins, DefaultConflictResolver.getInstance());
    }

    public static RuleBase loadFromInputStream(InputStream[] ins, ConflictResolver resolver) throws SAXException, IOException, IntegrationException {
        RuleBaseBuilder builder = new RuleBaseBuilder();
        builder.setConflictResolver(resolver);
        RuleBaseContext factoryContext = new RuleBaseContext();
        for (int i = 0; i < ins.length; ++i) {
            RuleSetReader reader = new RuleSetReader(factoryContext);
            RuleSet ruleSet = reader.read(ins[i]);
            builder.addRuleSet(ruleSet);
        }
        return builder.build();
    }

    public static RuleBase loadFromReader(Reader in) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromReader(in, DefaultConflictResolver.getInstance());
    }

    public static RuleBase loadFromReader(Reader in, ConflictResolver resolver) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromReader(new Reader[]{in}, resolver);
    }

    public static RuleBase loadFromReader(Reader[] ins) throws SAXException, IOException, IntegrationException {
        return RuleBaseLoader.loadFromReader(ins, DefaultConflictResolver.getInstance());
    }

    public static RuleBase loadFromReader(Reader[] ins, ConflictResolver resolver) throws SAXException, IOException, IntegrationException {
        RuleBaseContext factoryContext = new RuleBaseContext();
        RuleBaseBuilder builder = new RuleBaseBuilder(factoryContext);
        builder.setConflictResolver(resolver);
        for (int i = 0; i < ins.length; ++i) {
            RuleSetReader reader = new RuleSetReader(factoryContext);
            RuleSet ruleSet = reader.read(ins[i]);
            builder.addRuleSet(ruleSet);
        }
        return builder.build();
    }
}

