/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.rule.Declaration;
import org.drools.rule.FixedDuration;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.NoConsequenceException;
import org.drools.rule.NoParameterDeclarationException;
import org.drools.rule.RuleSet;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.Duration;
import org.drools.spi.ImportEntry;
import org.drools.spi.ObjectType;

public class Rule
implements Serializable {
    private RuleSet ruleSet;
    private final String name;
    private String documentation;
    private int salience;
    private final List parameterDeclarations = new ArrayList();
    private final List conditions = new ArrayList();
    private Consequence consequence;
    private Duration duration;
    private long loadOrder;
    private boolean noLoop;
    private Set imports;
    private Map applicationData;

    public Rule(String name, RuleSet ruleSet) {
        this.name = name;
        this.ruleSet = ruleSet;
        this.imports = Collections.EMPTY_SET;
        this.applicationData = Collections.EMPTY_MAP;
    }

    public Rule(String name) {
        this(name, null);
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDuration(long seconds) {
        this.duration = new FixedDuration(seconds);
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isValid() {
        return !this.getParameterDeclarations().isEmpty() && !this.getConditions().isEmpty() && this.getConsequence() != null;
    }

    public void checkValidity() throws InvalidRuleException {
        if (this.getParameterDeclarations().isEmpty()) {
            throw new NoParameterDeclarationException(this);
        }
        if (this.getConsequence() == null) {
            throw new NoConsequenceException(this);
        }
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public String getName() {
        return this.name;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int salience) {
        this.salience = salience;
    }

    public boolean getNoLoop() {
        return this.noLoop;
    }

    public void setNoLoop(boolean noLoop) {
        this.noLoop = noLoop;
    }

    public Declaration addParameterDeclaration(String identifier, ObjectType objectType) throws InvalidRuleException {
        if (this.getParameterDeclaration(identifier) != null) {
            throw new InvalidRuleException(this);
        }
        Declaration declaration = new Declaration(identifier, objectType, this.parameterDeclarations.size());
        this.parameterDeclarations.add(declaration);
        return declaration;
    }

    public Declaration getParameterDeclaration(String identifier) {
        Iterator declIter = this.parameterDeclarations.iterator();
        while (declIter.hasNext()) {
            Declaration eachDecl = (Declaration)declIter.next();
            if (!eachDecl.getIdentifier().equals(identifier)) continue;
            return eachDecl;
        }
        return null;
    }

    public List getParameterDeclarations() {
        return Collections.unmodifiableList(this.parameterDeclarations);
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public List getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public int getConditionSize() {
        return this.conditions.size();
    }

    public void setConsequence(Consequence consequence) {
        this.consequence = consequence;
    }

    public Consequence getConsequence() {
        return this.consequence;
    }

    public long getLoadOrder() {
        return this.loadOrder;
    }

    void setLoadOrder(long loadOrder) {
        this.loadOrder = loadOrder;
    }

    public void setImports(Set imports) {
        this.imports = imports;
    }

    public Set getImports(Class clazz) {
        HashSet<String> imports = new HashSet<String>();
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            ImportEntry importEntry = (ImportEntry)i.next();
            if (!clazz.isInstance(importEntry)) continue;
            imports.add(importEntry.getImportEntry());
        }
        return imports;
    }

    public void setApplicationData(Map applicationData) {
        this.applicationData = applicationData;
    }

    public Map getApplicationData() {
        return this.applicationData;
    }

    public String dump(String indent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent).append("Rule\n");
        buffer.append(indent).append("----\n");
        buffer.append(indent).append("name: ");
        buffer.append(this.name);
        buffer.append("\n");
        buffer.append(indent).append("salience: ");
        buffer.append(this.salience);
        buffer.append("\n");
        buffer.append(indent).append("load order: ");
        buffer.append(this.loadOrder);
        buffer.append("\n");
        buffer.append(indent).append("duration: ");
        buffer.append(this.duration);
        buffer.append("\n");
        Iterator i = this.parameterDeclarations.iterator();
        while (i.hasNext()) {
            buffer.append(indent).append(i.next());
        }
        i = this.conditions.iterator();
        while (i.hasNext()) {
            buffer.append(indent).append("condition:\n").append(indent).append(i.next()).append('\n');
        }
        buffer.append(indent).append("consequence:\n");
        buffer.append(indent).append(this.consequence);
        buffer.append("\n");
        return buffer.toString();
    }
}

