/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.annotation.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.DroolsException;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;
import org.drools.semantics.annotation.DroolsApplicationData;
import org.drools.semantics.annotation.DroolsCondition;
import org.drools.semantics.annotation.DroolsConsequence;
import org.drools.semantics.annotation.DroolsParameter;
import org.drools.semantics.annotation.model.ApplicationDataParameterValue;
import org.drools.semantics.annotation.model.KnowledgeHelperParameterValue;
import org.drools.semantics.annotation.model.ParameterValue;
import org.drools.semantics.annotation.model.PojoCondition;
import org.drools.semantics.annotation.model.PojoConsequence;
import org.drools.semantics.annotation.model.RuleReflectMethod;
import org.drools.semantics.annotation.model.TupleParameterValue;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.KnowledgeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnonatedPojoRuleBuilder {
    private static final Set<ParameterValueFactory> parameterValueFatories = new HashSet<ParameterValueFactory>();

    public static void registerParameterValueFactory(ParameterValueFactory factory) {
        for (ParameterValueFactory registeredFactory : parameterValueFatories) {
            if (factory.getParameterValueType() != registeredFactory.getParameterValueType()) continue;
            throw new IllegalArgumentException("ParameterValueFactory already registered: type=" + factory.getParameterValueType() + ", factory =" + factory + ", registered factory=" + registeredFactory);
        }
        parameterValueFatories.add(factory);
    }

    public Rule buildRule(Rule rule, Object pojo) throws DroolsException {
        Class<?> ruleClass = pojo.getClass();
        AnnonatedPojoRuleBuilder.buildConditions(rule, ruleClass, pojo);
        AnnonatedPojoRuleBuilder.buildConsequence(rule, ruleClass, pojo);
        return rule;
    }

    private static void buildConditions(Rule rule, Class<?> ruleClass, Object pojo) throws DroolsException {
        for (Method method : ruleClass.getMethods()) {
            DroolsCondition conditionAnnotation = method.getAnnotation(DroolsCondition.class);
            if (conditionAnnotation == null) continue;
            PojoCondition condition = AnnonatedPojoRuleBuilder.newPojoCondition(rule, pojo, method);
            rule.addCondition(condition);
        }
    }

    private static void buildConsequence(Rule rule, Class<?> ruleClass, Object pojo) throws DroolsException {
        PojoConsequence consequence = null;
        for (Method method : ruleClass.getMethods()) {
            DroolsConsequence consequenceAnnotation = method.getAnnotation(DroolsConsequence.class);
            if (consequenceAnnotation == null) continue;
            if (consequence != null) {
                throw new DroolsException("Rule must only contain one consequence method: class = " + ruleClass + ", method = " + method);
            }
            consequence = AnnonatedPojoRuleBuilder.newPojoConsequence(rule, pojo, method);
            rule.setConsequence(consequence);
        }
        if (consequence == null) {
            throw new DroolsException("Rule must define a consequence method: class = " + ruleClass);
        }
    }

    private static PojoCondition newPojoCondition(Rule rule, Object pojo, Method pojoMethod) throws DroolsException {
        AnnonatedPojoRuleBuilder.assertReturnType(pojoMethod, Boolean.TYPE);
        ParameterValidator parameterValidator = new ParameterValidator(){

            @Override
            public void assertParameter(ParameterValue newParameterValue, List<ParameterValue> parameterValues) throws DroolsException {
                if (newParameterValue instanceof KnowledgeHelperParameterValue) {
                    throw new DroolsException("Condition methods cannot declare a parameter of type KnowledgeHelper");
                }
            }
        };
        return new PojoCondition(new RuleReflectMethod(rule, pojo, pojoMethod, AnnonatedPojoRuleBuilder.getParameterValues(rule, pojoMethod, parameterValidator)));
    }

    private static PojoConsequence newPojoConsequence(Rule rule, Object pojo, Method pojoMethod) throws DroolsException {
        AnnonatedPojoRuleBuilder.assertReturnType(pojoMethod, Void.TYPE);
        ParameterValidator parameterValidator = new ParameterValidator(){
            private boolean hasDroolsParameterValue;

            @Override
            public void assertParameter(ParameterValue newParameterValue, List<ParameterValue> parameterValues) throws DroolsException {
                if (newParameterValue instanceof KnowledgeHelperParameterValue) {
                    if (this.hasDroolsParameterValue) {
                        throw new DroolsException("Consequence methods can only declare on parameter of type Drools");
                    }
                    this.hasDroolsParameterValue = true;
                }
            }
        };
        return new PojoConsequence(new RuleReflectMethod(rule, pojo, pojoMethod, AnnonatedPojoRuleBuilder.getParameterValues(rule, pojoMethod, parameterValidator)));
    }

    private static void assertReturnType(Method method, Class returnClass) throws DroolsException {
        if (method.getReturnType() != returnClass) {
            throw new DroolsException("Rule method returns the wrong class: method = " + method + ", expected return class = " + returnClass + ", actual return class = " + method.getReturnType());
        }
    }

    private static ParameterValue[] getParameterValues(Rule rule, Method method, ParameterValidator validator) throws DroolsException {
        Class<?>[] parameterClasses = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        for (int i = 0; i < parameterClasses.length; ++i) {
            Class<?> parameterClass = parameterClasses[i];
            ParameterValue parameterValue = null;
            try {
                parameterValue = AnnonatedPojoRuleBuilder.getParameterValue(rule, parameterClass, parameterAnnotations[i]);
                validator.assertParameter(parameterValue, parameterValues);
            }
            catch (DroolsException e) {
                AnnonatedPojoRuleBuilder.throwContextDroolsException(method, i, parameterClass, e);
            }
            parameterValues.add(parameterValue);
        }
        return parameterValues.toArray(new ParameterValue[parameterValues.size()]);
    }

    private static ParameterValue getParameterValue(Rule rule, Class<?> parameterClass, Annotation[] parameterAnnotations) throws DroolsException {
        for (ParameterValueFactory factory : parameterValueFatories) {
            ParameterValue parameterValue = factory.create(rule, parameterClass, parameterAnnotations);
            if (parameterValue == null) continue;
            return parameterValue;
        }
        throw new DroolsException("Method parameter type not recognized or not annotated");
    }

    private static void throwContextDroolsException(Method method, int i, Class<?> parameterClass, Exception e) throws DroolsException {
        throw new DroolsException(e.getMessage() + ": method = " + method + ", parameter[" + i + "] = " + parameterClass, e);
    }

    private static void assertNonConflictingParameterAnnotation(ParameterValue parameterValue) throws DroolsException {
        if (parameterValue != null) {
            throw new DroolsException("Method parameter contains conflicting @Drools annotations");
        }
    }

    static {
        AnnonatedPojoRuleBuilder.registerParameterValueFactory(new KnowledgeHelperParameterValueFactory());
        AnnonatedPojoRuleBuilder.registerParameterValueFactory(new DroolsTupleParameterValueFactory());
        AnnonatedPojoRuleBuilder.registerParameterValueFactory(new DroolsApplicationDataParameterValueFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DroolsApplicationDataParameterValueFactory
    extends AnnotationParameterValueFactory {
        public DroolsApplicationDataParameterValueFactory() {
            super(DroolsApplicationData.class);
        }

        @Override
        public Class<? extends ParameterValue> getParameterValueType() {
            return ApplicationDataParameterValue.class;
        }

        @Override
        public ParameterValue doCreate(Rule rule, Class<?> parameterClass, Annotation annotation) {
            String parameterId = ((DroolsApplicationData)annotation).value();
            return new ApplicationDataParameterValue(parameterId, parameterClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DroolsTupleParameterValueFactory
    extends AnnotationParameterValueFactory {
        public DroolsTupleParameterValueFactory() {
            super(DroolsParameter.class);
        }

        @Override
        public Class<? extends ParameterValue> getParameterValueType() {
            return TupleParameterValue.class;
        }

        @Override
        public ParameterValue doCreate(Rule rule, Class<?> parameterClass, Annotation annotation) throws InvalidRuleException {
            String parameterId = ((DroolsParameter)annotation).value();
            Declaration declaration = rule.getParameterDeclaration(parameterId);
            if (declaration == null) {
                ClassObjectType classObjectType = new ClassObjectType(parameterClass);
                declaration = rule.addParameterDeclaration(parameterId, classObjectType);
            }
            return new TupleParameterValue(declaration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KnowledgeHelperParameterValueFactory
    implements ParameterValueFactory {
        @Override
        public Class<? extends ParameterValue> getParameterValueType() {
            return KnowledgeHelperParameterValue.class;
        }

        @Override
        public ParameterValue create(Rule rule, Class<?> parameterClass, Annotation[] parameterAnnotations) {
            if (parameterClass != KnowledgeHelper.class) {
                return null;
            }
            return new KnowledgeHelperParameterValue(rule);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AnnotationParameterValueFactory
    implements ParameterValueFactory {
        private final Class<? extends Annotation> annotationClass;

        protected AnnotationParameterValueFactory(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        protected abstract ParameterValue doCreate(Rule var1, Class<?> var2, Annotation var3) throws InvalidRuleException;

        @Override
        public ParameterValue create(Rule rule, Class<?> parameterClass, Annotation[] parameterAnnotations) throws DroolsException {
            Annotation annotation = this.getAnnotation(this.annotationClass, parameterAnnotations);
            if (annotation == null) {
                return null;
            }
            return this.doCreate(rule, parameterClass, annotation);
        }

        private Annotation getAnnotation(Class<? extends Annotation> annotationClass, Annotation[] parameterAnnotations) {
            for (Annotation annotation : parameterAnnotations) {
                if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                return annotation;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParameterValueFactory {
        public Class<? extends ParameterValue> getParameterValueType();

        public ParameterValue create(Rule var1, Class<?> var2, Annotation[] var3) throws DroolsException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParameterValidator {
        public void assertParameter(ParameterValue var1, List<ParameterValue> var2) throws DroolsException;
    }
}

