/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.annotation.model;

import java.util.ArrayList;
import org.drools.rule.Declaration;
import org.drools.semantics.annotation.model.ParameterValue;
import org.drools.semantics.annotation.model.RuleReflectMethod;
import org.drools.semantics.annotation.model.TupleParameterValue;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.Tuple;

class PojoCondition
implements Condition {
    private final RuleReflectMethod ruleMethod;
    private final Declaration[] requiredDeclarations;

    public PojoCondition(RuleReflectMethod ruleMethod) {
        this.ruleMethod = ruleMethod;
        this.requiredDeclarations = PojoCondition.extractDeclarations(ruleMethod.getParameterValues());
    }

    private static Declaration[] extractDeclarations(ParameterValue[] parameterValues) {
        ArrayList<Declaration> declarations = new ArrayList<Declaration>(parameterValues.length);
        for (ParameterValue value : parameterValues) {
            if (!(value instanceof TupleParameterValue)) continue;
            declarations.add(((TupleParameterValue)value).getDeclaration());
        }
        return declarations.toArray(new Declaration[declarations.size()]);
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDeclarations;
    }

    public boolean isAllowed(Tuple tuple) throws ConditionException {
        try {
            return (Boolean)this.ruleMethod.invokeMethod(tuple);
        }
        catch (Exception e) {
            throw new ConditionException(e);
        }
    }

    public String toString() {
        return this.ruleMethod.toString();
    }
}

