/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.janino.ByteArrayClassLoader;
import net.janino.ClassBodyEvaluator;
import net.janino.Java;
import net.janino.Parser;
import net.janino.Scanner;
import org.drools.rule.RuleSet;
import org.drools.spi.Functions;
import org.drools.spi.RuleBaseContext;

public class JavaFunctions
implements Functions {
    private String text;
    private transient Class functionsClass;
    private RuleSet ruleSet;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public JavaFunctions(RuleSet ruleSet, String text) throws Scanner.ScanException, IOException, Java.CompileException, Parser.ParseException {
        this.text = text;
        this.ruleSet = ruleSet;
        RuleBaseContext ruleBaseContext = ruleSet.getRuleBaseContext();
        ClassLoader classLoader = (ClassLoader)ruleBaseContext.get("java-classLoader");
        if (classLoader == null) {
            classLoader = new ByteArrayClassLoader(Thread.currentThread().getContextClassLoader());
            ruleBaseContext.put("java-classLoader", classLoader);
        }
        ClassBodyEvaluator classBody = new ClassBodyEvaluator(new Scanner(null, (Reader)new StringReader(this.text)), classLoader);
        this.functionsClass = classBody.evaluate();
    }

    public String getText() {
        return this.text;
    }

    public Class getFunctionsClass() {
        return this.functionsClass;
    }

    public String getSemantic() {
        return "java";
    }
}

